/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.ui;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolTipUI;
import javax.swing.text.View;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceTextUtilities;
import org.pushingpixels.substance.internal.utils.filters.RenderingUtils;

public class SubstanceToolTipUI
extends BasicToolTipUI {
    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new SubstanceToolTipUI();
    }

    @Override
    public void paint(Graphics g2, JComponent c) {
        Font font = c.getFont();
        Dimension size = c.getSize();
        if (c.isOpaque()) {
            g2.setColor(c.getBackground());
            g2.fillRect(0, 0, size.width, size.height);
        }
        g2.setColor(c.getForeground());
        g2.setFont(font);
        String tipText = ((JToolTip)c).getTipText();
        if (tipText == null) {
            tipText = "";
        }
        Insets insets = c.getInsets();
        Rectangle paintTextR = new Rectangle(insets.left + 3, insets.top + 1, size.width - (insets.left + insets.right + 6), size.height - (insets.top + insets.bottom + 1));
        View v = (View)c.getClientProperty("html");
        if (v != null) {
            v.paint(g2, paintTextR);
        } else {
            SubstanceTextUtilities.paintText(g2, c, paintTextR, tipText, -1, font, c.getForeground(), null);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Font font = c.getFont();
        Insets insets = c.getInsets();
        Dimension prefSize = new Dimension(insets.left + insets.right, insets.top + insets.bottom);
        String text = ((JToolTip)c).getTipText();
        if (text == null || text.equals("")) {
            text = "";
        } else {
            View v;
            View view = v = c != null ? (View)c.getClientProperty("html") : null;
            if (v != null) {
                prefSize.width += (int)(v.getPreferredSpan(0) + 6.0f);
                prefSize.height += (int)(v.getPreferredSpan(1) + 2.0f);
            } else {
                FontMetrics fm = c.getFontMetrics(font);
                prefSize.width += fm.stringWidth(text) + 6;
                prefSize.height += fm.getHeight() + 2;
            }
        }
        return prefSize;
    }

    @Override
    public void update(Graphics g2, JComponent c) {
        Graphics2D g2d = (Graphics2D)g2.create();
        RenderingUtils.installDesktopHints(g2d, c);
        super.update(g2d, c);
        g2d.dispose();
    }
}

