/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.UIManager;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicDesktopIconUI;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.SubstanceWidget;
import org.pushingpixels.substance.internal.SubstanceWidgetRepository;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceInternalFrameTitlePane;

public class SubstanceDesktopIconUI
extends BasicDesktopIconUI {
    private MouseInputListener substanceLabelMouseInputListener;
    private int width;
    private Set<SubstanceWidget> lafWidgets;

    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new SubstanceDesktopIconUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        Font f = this.desktopIcon.getFont();
        if (f == null || f instanceof UIResource) {
            this.desktopIcon.setFont(UIManager.getFont("DesktopIcon.font"));
        }
        this.width = UIManager.getInt("DesktopIcon.width");
        this.desktopIcon.setBackground(SubstanceCoreUtilities.getSkin(this.desktopIcon.getInternalFrame()).getBackgroundColorScheme(SubstanceSlices.DecorationAreaType.SECONDARY_TITLE_PANE).getBackgroundFillColor());
        for (SubstanceWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    @Override
    protected void uninstallDefaults() {
        for (SubstanceWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
        super.uninstallDefaults();
    }

    @Override
    protected void installComponents() {
        this.frame = this.desktopIcon.getInternalFrame();
        this.iconPane = new SubstanceInternalFrameTitlePane(this.frame);
        this.iconPane.setOpaque(false);
        this.desktopIcon.setLayout(new BorderLayout());
        this.desktopIcon.add((Component)this.iconPane, "Center");
        for (SubstanceWidget lafWidget : this.lafWidgets) {
            lafWidget.installComponents();
        }
    }

    @Override
    protected void uninstallComponents() {
        ((SubstanceInternalFrameTitlePane)this.iconPane).uninstall();
        this.desktopIcon.setLayout(null);
        this.desktopIcon.remove(this.iconPane);
        for (SubstanceWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallComponents();
        }
        this.frame = null;
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.substanceLabelMouseInputListener = this.createMouseInputListener();
        this.iconPane.addMouseMotionListener(this.substanceLabelMouseInputListener);
        this.iconPane.addMouseListener(this.substanceLabelMouseInputListener);
        for (SubstanceWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    @Override
    protected void uninstallListeners() {
        ((SubstanceInternalFrameTitlePane)this.iconPane).uninstallListeners();
        this.iconPane.removeMouseMotionListener(this.substanceLabelMouseInputListener);
        this.iconPane.removeMouseListener(this.substanceLabelMouseInputListener);
        this.substanceLabelMouseInputListener = null;
        for (SubstanceWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
        super.uninstallListeners();
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return this.getMinimumSize(c);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return new Dimension(this.width, this.desktopIcon.getLayout().minimumLayoutSize((Container)this.desktopIcon).height);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return this.getMinimumSize(c);
    }

    @Override
    public void installUI(JComponent c) {
        this.lafWidgets = SubstanceWidgetRepository.getRepository().getMatchingWidgets(c);
        super.installUI(c);
        c.setOpaque(false);
        for (SubstanceWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        for (SubstanceWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
        SubstanceInternalFrameTitlePane thePane = (SubstanceInternalFrameTitlePane)this.iconPane;
        super.uninstallUI(c);
        thePane.uninstallListeners();
    }

    public JComponent getComponentForHover() {
        return this.iconPane;
    }

    public void installIfNecessary(JInternalFrame.JDesktopIcon jdi) {
        if (this.desktopIcon == null) {
            this.installUI(jdi);
        }
    }

    public void uninstallIfNecessary(JInternalFrame.JDesktopIcon jdi) {
        if (this.desktopIcon == jdi) {
            this.uninstallUI(jdi);
        }
    }

    void setWindowModified(boolean isWindowModified) {
        ((SubstanceInternalFrameTitlePane)this.iconPane).getCloseButton().putClientProperty("substancelaf.internal.contentsModified", isWindowModified);
    }
}

