/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="union cl_device_topology_amd")
public class CLDeviceTopologyAMD
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int RAW;
    public static final int RAW_TYPE;
    public static final int RAW_DATA;
    public static final int PCIE;
    public static final int PCIE_TYPE;
    public static final int PCIE_BUS;
    public static final int PCIE_DEVICE;
    public static final int PCIE_FUNCTION;

    public CLDeviceTopologyAMD(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), CLDeviceTopologyAMD.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="cl_uint")
    public int raw_type() {
        return CLDeviceTopologyAMD.nraw_type(this.address());
    }

    @NativeType(value="cl_uint[5]")
    public IntBuffer raw_data() {
        return CLDeviceTopologyAMD.nraw_data(this.address());
    }

    @NativeType(value="cl_uint")
    public int raw_data(int index) {
        return CLDeviceTopologyAMD.nraw_data(this.address(), index);
    }

    @NativeType(value="cl_uint")
    public int pcie_type() {
        return CLDeviceTopologyAMD.npcie_type(this.address());
    }

    @NativeType(value="cl_char")
    public byte pcie_bus() {
        return CLDeviceTopologyAMD.npcie_bus(this.address());
    }

    @NativeType(value="cl_char")
    public byte pcie_device() {
        return CLDeviceTopologyAMD.npcie_device(this.address());
    }

    @NativeType(value="cl_char")
    public byte pcie_function() {
        return CLDeviceTopologyAMD.npcie_function(this.address());
    }

    public static CLDeviceTopologyAMD malloc() {
        return CLDeviceTopologyAMD.wrap(CLDeviceTopologyAMD.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static CLDeviceTopologyAMD calloc() {
        return CLDeviceTopologyAMD.wrap(CLDeviceTopologyAMD.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static CLDeviceTopologyAMD create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return CLDeviceTopologyAMD.wrap(CLDeviceTopologyAMD.class, MemoryUtil.memAddress(container), container);
    }

    public static CLDeviceTopologyAMD create(long address) {
        return CLDeviceTopologyAMD.wrap(CLDeviceTopologyAMD.class, address);
    }

    @Nullable
    public static CLDeviceTopologyAMD createSafe(long address) {
        return address == 0L ? null : CLDeviceTopologyAMD.wrap(CLDeviceTopologyAMD.class, address);
    }

    public static Buffer malloc(int capacity) {
        return CLDeviceTopologyAMD.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(CLDeviceTopologyAMD.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return CLDeviceTopologyAMD.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CLDeviceTopologyAMD.__create(capacity, SIZEOF);
        return CLDeviceTopologyAMD.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return CLDeviceTopologyAMD.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : CLDeviceTopologyAMD.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static CLDeviceTopologyAMD mallocStack() {
        return CLDeviceTopologyAMD.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CLDeviceTopologyAMD callocStack() {
        return CLDeviceTopologyAMD.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CLDeviceTopologyAMD mallocStack(MemoryStack stack) {
        return CLDeviceTopologyAMD.malloc(stack);
    }

    @Deprecated
    public static CLDeviceTopologyAMD callocStack(MemoryStack stack) {
        return CLDeviceTopologyAMD.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return CLDeviceTopologyAMD.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return CLDeviceTopologyAMD.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CLDeviceTopologyAMD.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CLDeviceTopologyAMD.calloc(capacity, stack);
    }

    public static CLDeviceTopologyAMD malloc(MemoryStack stack) {
        return CLDeviceTopologyAMD.wrap(CLDeviceTopologyAMD.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CLDeviceTopologyAMD calloc(MemoryStack stack) {
        return CLDeviceTopologyAMD.wrap(CLDeviceTopologyAMD.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return CLDeviceTopologyAMD.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return CLDeviceTopologyAMD.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nraw_type(long struct) {
        return UNSAFE.getInt(null, struct + (long)RAW_TYPE);
    }

    public static IntBuffer nraw_data(long struct) {
        return MemoryUtil.memIntBuffer(struct + (long)RAW_DATA, 5);
    }

    public static int nraw_data(long struct, int index) {
        return UNSAFE.getInt(null, struct + (long)RAW_DATA + Checks.check(index, 5) * 4L);
    }

    public static int npcie_type(long struct) {
        return UNSAFE.getInt(null, struct + (long)PCIE_TYPE);
    }

    public static byte npcie_bus(long struct) {
        return UNSAFE.getByte(null, struct + (long)PCIE_BUS);
    }

    public static byte npcie_device(long struct) {
        return UNSAFE.getByte(null, struct + (long)PCIE_DEVICE);
    }

    public static byte npcie_function(long struct) {
        return UNSAFE.getByte(null, struct + (long)PCIE_FUNCTION);
    }

    static {
        Struct.Layout layout = CLDeviceTopologyAMD.__union(CLDeviceTopologyAMD.__struct(CLDeviceTopologyAMD.__member(4), CLDeviceTopologyAMD.__array(4, 5)), CLDeviceTopologyAMD.__struct(CLDeviceTopologyAMD.__member(4), CLDeviceTopologyAMD.__padding(17, true), CLDeviceTopologyAMD.__member(1), CLDeviceTopologyAMD.__member(1), CLDeviceTopologyAMD.__member(1)));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        RAW = layout.offsetof(0);
        RAW_TYPE = layout.offsetof(1);
        RAW_DATA = layout.offsetof(2);
        PCIE = layout.offsetof(3);
        PCIE_TYPE = layout.offsetof(4);
        PCIE_BUS = layout.offsetof(6);
        PCIE_DEVICE = layout.offsetof(7);
        PCIE_FUNCTION = layout.offsetof(8);
    }

    public static class Buffer
    extends StructBuffer<CLDeviceTopologyAMD, Buffer>
    implements NativeResource {
        private static final CLDeviceTopologyAMD ELEMENT_FACTORY = CLDeviceTopologyAMD.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected CLDeviceTopologyAMD getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="cl_uint")
        public int raw_type() {
            return CLDeviceTopologyAMD.nraw_type(this.address());
        }

        @NativeType(value="cl_uint[5]")
        public IntBuffer raw_data() {
            return CLDeviceTopologyAMD.nraw_data(this.address());
        }

        @NativeType(value="cl_uint")
        public int raw_data(int index) {
            return CLDeviceTopologyAMD.nraw_data(this.address(), index);
        }

        @NativeType(value="cl_uint")
        public int pcie_type() {
            return CLDeviceTopologyAMD.npcie_type(this.address());
        }

        @NativeType(value="cl_char")
        public byte pcie_bus() {
            return CLDeviceTopologyAMD.npcie_bus(this.address());
        }

        @NativeType(value="cl_char")
        public byte pcie_device() {
            return CLDeviceTopologyAMD.npcie_device(this.address());
        }

        @NativeType(value="cl_char")
        public byte pcie_function() {
            return CLDeviceTopologyAMD.npcie_function(this.address());
        }
    }
}

