/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONTokener {
    boolean useLastChar;
    int index;
    Reader reader;
    char lastChar;

    public JSONTokener(String var1) {
        this(new StringReader(var1));
    }

    public JSONTokener(Reader var1) {
        this.reader = var1.markSupported() ? var1 : new BufferedReader(var1);
        this.useLastChar = false;
        this.index = 0;
    }

    public char nextClean() throws JSONException {
        char var1;
        while ((var1 = this.next()) != '\u0000' && var1 <= ' ') {
        }
        return var1;
    }

    public char next() throws JSONException {
        int var1;
        if (this.useLastChar) {
            this.useLastChar = false;
            if (this.lastChar != '\u0000') {
                ++this.index;
            }
            return this.lastChar;
        }
        try {
            var1 = this.reader.read();
        }
        catch (IOException var3) {
            throw new JSONException(var3);
        }
        if (var1 <= 0) {
            this.lastChar = '\u0000';
            return '\u0000';
        }
        ++this.index;
        this.lastChar = (char)var1;
        return this.lastChar;
    }

    public String nextString(char var1) throws JSONException {
        StringBuffer var3 = new StringBuffer();
        block13: while (true) {
            char var2 = this.next();
            switch (var2) {
                case '\u0000': 
                case '\n': 
                case '\r': {
                    throw this.syntaxError("Unterminated string");
                }
                case '\\': {
                    var2 = this.next();
                    switch (var2) {
                        case 'b': {
                            var3.append('\b');
                            continue block13;
                        }
                        default: {
                            var3.append(var2);
                            continue block13;
                        }
                        case 'f': {
                            var3.append('\f');
                            continue block13;
                        }
                        case 'n': {
                            var3.append('\n');
                            continue block13;
                        }
                        case 'r': {
                            var3.append('\r');
                            continue block13;
                        }
                        case 't': {
                            var3.append('\t');
                            continue block13;
                        }
                        case 'u': {
                            var3.append((char)Integer.parseInt(this.next(4), 16));
                            continue block13;
                        }
                        case 'x': 
                    }
                    var3.append((char)Integer.parseInt(this.next(2), 16));
                    continue block13;
                }
            }
            if (var2 == var1) {
                return var3.toString();
            }
            var3.append(var2);
        }
    }

    public String toString() {
        return " at character " + this.index;
    }

    public void back() throws JSONException {
        if (!this.useLastChar && this.index > 0) {
            --this.index;
        } else {
            throw new JSONException("Stepping back two steps is not supported");
        }
        this.useLastChar = true;
    }

    public JSONException syntaxError(String var1) {
        return new JSONException(var1 + this.toString());
    }

    public String next(int var1) throws JSONException {
        if (var1 == 0) {
            return "";
        }
        char[] var2 = new char[var1];
        int var3 = 0;
        if (this.useLastChar) {
            this.useLastChar = false;
            var2[0] = this.lastChar;
            var3 = 1;
        }
        try {
            int var4;
            while (var3 < var1 && (var4 = this.reader.read(var2, var3, var1 - var3)) != -1) {
                var3 += var4;
            }
        }
        catch (IOException var6) {
            throw new JSONException(var6);
        }
        this.index += var3;
        if (var3 < var1) {
            throw this.syntaxError("Substring bounds error");
        }
        this.lastChar = var2[var1 - 1];
        return new String(var2);
    }

    public Object nextValue() throws JSONException {
        char var1 = this.nextClean();
        switch (var1) {
            case '\"': 
            case '\'': {
                return this.nextString(var1);
            }
            case '(': 
            case '[': {
                this.back();
                return new JSONArray(this);
            }
            case '{': {
                this.back();
                return new JSONObject(this);
            }
        }
        StringBuffer var3 = new StringBuffer();
        while (var1 >= ' ' && ",:]}/\\\"[{;=#".indexOf(var1) < 0) {
            var3.append(var1);
            var1 = this.next();
        }
        this.back();
        String var2 = var3.toString().trim();
        if (var2.equals("")) {
            throw this.syntaxError("Missing value");
        }
        return JSONObject.stringToValue(var2);
    }

    public String nextTo(String var1) throws JSONException {
        StringBuffer var3 = new StringBuffer();
        while (true) {
            char var2;
            if (var1.indexOf(var2 = this.next()) >= 0 || var2 == '\u0000' || var2 == '\n' || var2 == '\r') {
                if (var2 != '\u0000') {
                    this.back();
                }
                return var3.toString().trim();
            }
            var3.append(var2);
        }
    }

    public boolean more() throws JSONException {
        char var1 = this.next();
        if (var1 == '\u0000') {
            return false;
        }
        this.back();
        return true;
    }

    public char skipTo(char var1) throws JSONException {
        char var2;
        try {
            int var3 = this.index;
            this.reader.mark(Integer.MAX_VALUE);
            do {
                if ((var2 = this.next()) != '\u0000') continue;
                this.reader.reset();
                this.index = var3;
                char var10000 = var2;
                return var10000;
            } while (var2 != var1);
        }
        catch (IOException var5) {
            throw new JSONException(var5);
        }
        this.back();
        return var2;
    }

    public String nextTo(char var1) throws JSONException {
        StringBuffer var2 = new StringBuffer();
        while (true) {
            char var3;
            if ((var3 = this.next()) == var1 || var3 == '\u0000' || var3 == '\n' || var3 == '\r') {
                if (var3 != '\u0000') {
                    this.back();
                }
                return var2.toString().trim();
            }
            var2.append(var3);
        }
    }

    public char next(char var1) throws JSONException {
        char var2 = this.next();
        if (var2 != var1) {
            throw this.syntaxError("Expected '" + var1 + "' and instead saw '" + var2 + "'");
        }
        return var2;
    }

    public static int dehexchar(char var0) {
        return var0 >= '0' && var0 <= '9' ? var0 - 48 : (var0 >= 'A' && var0 <= 'F' ? var0 - 55 : (var0 >= 'a' && var0 <= 'f' ? var0 - 87 : -1));
    }
}

