/*
 * Decompiled with CFR 0.152.
 */
package org.jire.rspscfproxy;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.timeout.IdleStateEvent;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jire.rspscfproxy.ProxyClientChannelClosedEvent;
import org.jire.rspscfproxy.ProxyClientHandshakeCompleteEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u001d2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001dB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0002H\u0014J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0007H\u0002J\u0018\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0007H\u0002J\u0018\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0002H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jire/rspscfproxy/ProxyServerChannelHandler;", "Lio/netty/channel/SimpleChannelInboundHandler;", "Lio/netty/buffer/ByteBuf;", "bootstrap", "Lio/netty/bootstrap/Bootstrap;", "(Lio/netty/bootstrap/Bootstrap;)V", "clientChannel", "Lio/netty/channel/Channel;", "reconnectDelay", "", "channelActive", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "channelInactive", "channelRead0", "msg", "channelReadComplete", "channelWritabilityChanged", "connect", "channel", "exceptionCaught", "cause", "", "reconnect", "userEventTriggered", "evt", "", "writeToClientChannel", "Companion", "rsps-cf-proxy"})
public final class ProxyServerChannelHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Bootstrap bootstrap;
    @Nullable
    private volatile Channel clientChannel;
    private long reconnectDelay;
    private static final int MAX_FRAGMENT_SIZE = 65536;
    private static final long INITIAL_RECONNECT_DELAY = 1L;
    @NotNull
    private static final Logger logger;

    public ProxyServerChannelHandler(@NotNull Bootstrap bootstrap) {
        Intrinsics.checkNotNullParameter(bootstrap, "bootstrap");
        super(false);
        this.bootstrap = bootstrap;
        this.reconnectDelay = 1L;
    }

    private final void connect(Channel channel) {
        logger.info("Connecting to {}...", (Object)channel.remoteAddress());
        this.bootstrap.connect().addListener(arg_0 -> ProxyServerChannelHandler.connect$lambda$0(this, channel, arg_0));
    }

    private final void reconnect(Channel channel) {
        long reconnectDelay = this.reconnectDelay++;
        logger.info("Reconnecting {} in {} seconds", (Object)channel.remoteAddress(), (Object)reconnectDelay);
        channel.eventLoop().schedule(() -> ProxyServerChannelHandler.reconnect$lambda$1(this, channel), reconnectDelay, TimeUnit.SECONDS);
    }

    @Override
    public void channelActive(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        Channel channel = ctx.channel();
        Intrinsics.checkNotNullExpressionValue(channel, "channel(...)");
        this.connect(channel);
    }

    @Override
    public void userEventTriggered(@NotNull ChannelHandlerContext ctx, @NotNull Object evt) {
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        Intrinsics.checkNotNullParameter(evt, "evt");
        Object object = evt;
        if (object instanceof IdleStateEvent) {
            ctx.close();
        } else if (object instanceof ProxyClientHandshakeCompleteEvent) {
            Channel clientChannel;
            this.clientChannel = clientChannel = ((ProxyClientHandshakeCompleteEvent)evt).getClientChannel();
            this.reconnectDelay = 1L;
            ctx.read();
            ctx.channel().config().setAutoRead(true);
            logger.info("Client connected: {}", (Object)clientChannel.remoteAddress());
        } else if (Intrinsics.areEqual(object, ProxyClientChannelClosedEvent.INSTANCE)) {
            Channel channel = ctx.channel();
            channel.config().setAutoRead(false);
            this.clientChannel = null;
            Intrinsics.checkNotNull(channel);
            this.reconnect(channel);
        }
    }

    @Override
    protected void channelRead0(@NotNull ChannelHandlerContext ctx, @NotNull ByteBuf msg) {
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        Intrinsics.checkNotNullParameter(msg, "msg");
        Channel channel = this.clientChannel;
        Intrinsics.checkNotNull(channel);
        Channel clientChannel = channel;
        this.writeToClientChannel(clientChannel, msg);
    }

    @Override
    public void channelReadComplete(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        Channel channel = this.clientChannel;
        Intrinsics.checkNotNull(channel);
        Channel clientChannel = channel;
        clientChannel.flush();
        if (!clientChannel.isWritable()) {
            clientChannel.config().setAutoRead(false);
        }
    }

    @Override
    public void channelWritabilityChanged(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        Channel channel = ctx.channel();
        if (channel.isWritable()) {
            channel.config().setAutoRead(true);
        }
    }

    @Override
    public void exceptionCaught(@NotNull ChannelHandlerContext ctx, @NotNull Throwable cause) {
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        Intrinsics.checkNotNullParameter(cause, "cause");
        ctx.close();
        logger.error("Server exception caught " + ctx.channel().remoteAddress(), cause);
    }

    @Override
    public void channelInactive(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        ctx.close();
        logger.warn("Server channel inactive: {}", (Object)ctx.channel().localAddress());
        Channel clientChannel = this.clientChannel;
        if (clientChannel != null) {
            this.clientChannel = null;
            clientChannel.close();
        }
    }

    private final void writeToClientChannel(Channel clientChannel, ByteBuf msg) {
        int msgSize = msg.readableBytes();
        if (msgSize == 0) {
            return;
        }
        if (msgSize > 65536) {
            while (msg.isReadable()) {
                int fragmentSize = Math.min(msg.readableBytes(), 65536);
                ByteBuf fragment = msg.readRetainedSlice(fragmentSize);
                BinaryWebSocketFrame frame = new BinaryWebSocketFrame(fragment);
                clientChannel.write(frame, clientChannel.voidPromise());
            }
        } else {
            BinaryWebSocketFrame frame = new BinaryWebSocketFrame(msg);
            clientChannel.write(frame, clientChannel.voidPromise());
        }
    }

    private static final void connect$lambda$0(ProxyServerChannelHandler this$0, Channel $channel, ChannelFuture it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($channel, "$channel");
        if (!it.isSuccess()) {
            logger.error("Failed to connect client", it.cause());
            this$0.reconnect($channel);
        }
    }

    private static final void reconnect$lambda$1(ProxyServerChannelHandler this$0, Channel $channel) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($channel, "$channel");
        this$0.connect($channel);
    }

    static {
        Logger logger = LoggerFactory.getLogger(ProxyServerChannelHandler.class);
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        ProxyServerChannelHandler.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jire/rspscfproxy/ProxyServerChannelHandler$Companion;", "", "()V", "INITIAL_RECONNECT_DELAY", "", "MAX_FRAGMENT_SIZE", "", "logger", "Lorg/slf4j/Logger;", "rsps-cf-proxy"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

