/*
 * Decompiled with CFR 0.152.
 */
package org.jire.rspscfproxy;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketClientProtocolHandler;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.timeout.IdleStateHandler;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jire.rspscfproxy.ProxyClientChannelHandler;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0014R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jire/rspscfproxy/ProxyClientChannelInitializer;", "Lio/netty/channel/ChannelInitializer;", "Lio/netty/channel/socket/SocketChannel;", "sslContext", "Lio/netty/handler/ssl/SslContext;", "timeoutMillis", "", "uri", "Ljava/net/URI;", "handler", "Lorg/jire/rspscfproxy/ProxyClientChannelHandler;", "(Lio/netty/handler/ssl/SslContext;JLjava/net/URI;Lorg/jire/rspscfproxy/ProxyClientChannelHandler;)V", "initChannel", "", "ch", "rsps-cf-proxy"})
public final class ProxyClientChannelInitializer
extends ChannelInitializer<SocketChannel> {
    @NotNull
    private final SslContext sslContext;
    private final long timeoutMillis;
    @NotNull
    private final URI uri;
    @NotNull
    private final ProxyClientChannelHandler handler;

    public ProxyClientChannelInitializer(@NotNull SslContext sslContext, long timeoutMillis, @NotNull URI uri, @NotNull ProxyClientChannelHandler handler) {
        Intrinsics.checkNotNullParameter(sslContext, "sslContext");
        Intrinsics.checkNotNullParameter(uri, "uri");
        Intrinsics.checkNotNullParameter(handler, "handler");
        this.sslContext = sslContext;
        this.timeoutMillis = timeoutMillis;
        this.uri = uri;
        this.handler = handler;
    }

    @Override
    protected void initChannel(@NotNull SocketChannel ch) {
        Intrinsics.checkNotNullParameter(ch, "ch");
        ChannelHandler[] channelHandlerArray = new ChannelHandler[]{new IdleStateHandler(true, 0L, 0L, this.timeoutMillis, TimeUnit.MILLISECONDS)};
        ChannelPipeline channelPipeline = ch.pipeline().addLast(channelHandlerArray);
        channelHandlerArray = new ChannelHandler[]{this.sslContext.newHandler(ch.alloc(), this.uri.getHost(), this.uri.getPort())};
        ChannelPipeline channelPipeline2 = channelPipeline.addLast(channelHandlerArray);
        channelHandlerArray = new ChannelHandler[]{new HttpClientCodec()};
        ChannelPipeline channelPipeline3 = channelPipeline2.addLast(channelHandlerArray);
        channelHandlerArray = new ChannelHandler[]{new HttpObjectAggregator(65536)};
        ChannelPipeline channelPipeline4 = channelPipeline3.addLast(channelHandlerArray);
        channelHandlerArray = new ChannelHandler[]{new WebSocketClientProtocolHandler(WebSocketClientHandshakerFactory.newHandshaker(this.uri, WebSocketVersion.V13, null, true, EmptyHttpHeaders.INSTANCE, 65536))};
        ChannelPipeline channelPipeline5 = channelPipeline4.addLast(channelHandlerArray);
        channelHandlerArray = new ChannelHandler[]{this.handler};
        channelPipeline5.addLast(channelHandlerArray);
    }
}

