/*
 * Decompiled with CFR 0.152.
 */
package org.jire.rspscfproxy;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientProtocolHandler;
import io.netty.handler.timeout.IdleStateEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jire.rspscfproxy.ProxyClientChannelClosedEvent;
import org.jire.rspscfproxy.ProxyClientHandshakeCompleteEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0002H\u0014J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jire/rspscfproxy/ProxyClientChannelHandler;", "Lio/netty/channel/SimpleChannelInboundHandler;", "Lio/netty/handler/codec/http/websocketx/BinaryWebSocketFrame;", "serverChannel", "Lio/netty/channel/Channel;", "(Lio/netty/channel/Channel;)V", "channelInactive", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "channelRead0", "msg", "channelReadComplete", "channelWritabilityChanged", "exceptionCaught", "cause", "", "userEventTriggered", "evt", "", "Companion", "rsps-cf-proxy"})
public final class ProxyClientChannelHandler
extends SimpleChannelInboundHandler<BinaryWebSocketFrame> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Channel serverChannel;
    @NotNull
    private static final Logger logger;

    public ProxyClientChannelHandler(@NotNull Channel serverChannel) {
        Intrinsics.checkNotNullParameter(serverChannel, "serverChannel");
        super(false);
        this.serverChannel = serverChannel;
    }

    @Override
    protected void channelRead0(@NotNull ChannelHandlerContext ctx, @NotNull BinaryWebSocketFrame msg) {
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        Intrinsics.checkNotNullParameter(msg, "msg");
        ByteBuf content = msg.content();
        Channel serverChannel = this.serverChannel;
        serverChannel.write(content, serverChannel.voidPromise());
    }

    @Override
    public void channelReadComplete(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        Channel serverChannel = this.serverChannel;
        serverChannel.flush();
        if (!serverChannel.isWritable()) {
            serverChannel.config().setAutoRead(false);
        }
    }

    @Override
    public void channelWritabilityChanged(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        Channel channel = ctx.channel();
        if (channel.isWritable()) {
            channel.config().setAutoRead(true);
        }
    }

    @Override
    public void userEventTriggered(@NotNull ChannelHandlerContext ctx, @NotNull Object evt) {
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        Intrinsics.checkNotNullParameter(evt, "evt");
        Object object = evt;
        if (object instanceof IdleStateEvent) {
            ctx.close();
        } else if (object == WebSocketClientProtocolHandler.ClientHandshakeStateEvent.HANDSHAKE_COMPLETE) {
            ChannelPipeline channelPipeline = this.serverChannel.pipeline();
            Channel channel = ctx.channel();
            Intrinsics.checkNotNullExpressionValue(channel, "channel(...)");
            channelPipeline.fireUserEventTriggered(new ProxyClientHandshakeCompleteEvent(channel));
        } else if (object == WebSocketClientProtocolHandler.ClientHandshakeStateEvent.HANDSHAKE_TIMEOUT) {
            ctx.close();
        }
    }

    @Override
    public void exceptionCaught(@NotNull ChannelHandlerContext ctx, @NotNull Throwable cause) {
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        Intrinsics.checkNotNullParameter(cause, "cause");
        ctx.close();
        logger.error("Client exception caught " + ctx.channel().localAddress(), cause);
    }

    @Override
    public void channelInactive(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        ctx.close();
        this.serverChannel.pipeline().fireUserEventTriggered(ProxyClientChannelClosedEvent.INSTANCE);
    }

    static {
        Logger logger = LoggerFactory.getLogger(ProxyClientChannelHandler.class);
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        ProxyClientChannelHandler.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jire/rspscfproxy/ProxyClientChannelHandler$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "rsps-cf-proxy"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

