/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.util;

import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ScreenDeviceRefreshRateHelper {

    private static final Logger logger = LoggerFactory.getLogger(ScreenDeviceRefreshRateHelper.class);
    public static final int DEFAULT_REFRESH_RATE = 60;

    public static int getHighestRefreshRate() {
        int highestRefreshRate = 60;
        try {
            GraphicsDevice[] screenDevices;
            GraphicsEnvironment localGraphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            if (localGraphicsEnvironment != null && (screenDevices = localGraphicsEnvironment.getScreenDevices()) != null) {
                for (GraphicsDevice screenDevice : screenDevices) {
                    int refreshRate;
                    DisplayMode displayMode;
                    if (screenDevice == null || (displayMode = screenDevice.getDisplayMode()) == null || (refreshRate = displayMode.getRefreshRate()) <= highestRefreshRate) continue;
                    highestRefreshRate = refreshRate;
                }
            }
        }
        catch (Exception e) {
            logger.error("Failed to retrieve highest refresh rate", e);
        }
        return highestRefreshRate;
    }
}

