/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.xpdrop;

import java.awt.Color;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.Units;

@ConfigGroup(value="xpdrop")
public interface XpDropConfig
extends Config {
    @ConfigItem(keyName="hideSkillIcons", name="Hide skill icons", description="Configure if XP drops will show their respective skill icons", position=0)
    default public boolean hideSkillIcons() {
        return false;
    }

    @ConfigItem(keyName="standardColor", name="Standard Color", description="XP drop color when no prayer is active", position=1)
    public Color standardColor();

    @ConfigItem(keyName="meleePrayerColor", name="Melee Prayer Color", description="XP drop color when a melee prayer is active", position=2)
    default public Color getMeleePrayerColor() {
        return new Color(21, 128, 173);
    }

    @ConfigItem(keyName="rangePrayerColor", name="Range Prayer Color", description="XP drop color when a range prayer is active", position=3)
    default public Color getRangePrayerColor() {
        return new Color(21, 128, 173);
    }

    @ConfigItem(keyName="magePrayerColor", name="Mage Prayer Color", description="XP drop color when a mage prayer is active", position=4)
    default public Color getMagePrayerColor() {
        return new Color(21, 128, 173);
    }

    @ConfigItem(keyName="fakeXpDropDelay", name="Fake Xp Drop delay", description="Configures how many ticks should pass between fake XP drops, 0 to disable", position=5)
    @Units(value=" ticks")
    default public int fakeXpDropDelay() {
        return 0;
    }

    @ConfigItem(keyName="showdamagedrops", name="Show Damage on XP Drop", description="Show what you hit next to the XP drop", position=5)
    default public DamageMode showdamagedrops() {
        return DamageMode.NONE;
    }

    @ConfigItem(keyName="damageColor", name="Damage Color", description="The color you want the text to be for damage", position=6)
    default public Color getDamageColor() {
        return Color.RED;
    }

    public static enum DamageMode {
        NONE,
        ABOVE_OPPONENT,
        IN_XP_DROP;

    }
}

