/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.woodcutting;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Provides;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.NPC;
import net.runelite.api.Point;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.AnimationChanged;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameObjectDespawned;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.InteractingChanged;
import net.runelite.api.events.ItemSpawned;
import net.runelite.api.events.NpcDespawned;
import net.runelite.api.events.NpcSpawned;
import net.runelite.client.Notifier;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.woodcutting.Tree;
import net.runelite.client.plugins.woodcutting.TreeRespawn;
import net.runelite.client.plugins.woodcutting.WoodcuttingConfig;
import net.runelite.client.plugins.woodcutting.WoodcuttingOverlay;
import net.runelite.client.plugins.woodcutting.WoodcuttingSceneOverlay;
import net.runelite.client.plugins.woodcutting.WoodcuttingSession;
import net.runelite.client.plugins.woodcutting.config.ClueNestTier;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Woodcutting", description="Show woodcutting statistics and/or bird nest notifications", tags={"birds", "nest", "notifications", "overlay", "skilling", "wc", "forestry"}, enabledByDefault=false)
public class WoodcuttingPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(WoodcuttingPlugin.class);
    static final Set<Integer> WOODCUTTING_ANIMS = ImmutableSet.of(Integer.valueOf(879), Integer.valueOf(877), Integer.valueOf(875), Integer.valueOf(873), Integer.valueOf(871), Integer.valueOf(869), new Integer[]{867, 8303, 2846, 24, 2117, 7264, 8324, 8778, 10064, 10065, 10066, 10067, 10068, 10069, 10070, 10071, 10072, 10074});
    private static final Pattern WOOD_CUT_PATTERN = Pattern.compile("You get (?:some|an)[\\w ]+(?:logs?|mushrooms)\\.");
    private static final Pattern ANIMA_BARK_PATTERN = Pattern.compile("You've been awarded <col=[0-9a-f]+>(\\d+) Anima-infused bark</col>\\.");
    @Inject
    private Notifier notifier;
    @Inject
    private Client client;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private WoodcuttingOverlay overlay;
    @Inject
    private WoodcuttingSceneOverlay treesOverlay;
    @Inject
    private WoodcuttingConfig config;
    @Nullable
    private WoodcuttingSession session;
    private final Set<GameObject> treeObjects = new HashSet<GameObject>();
    private final List<GameObject> roots = new ArrayList<GameObject>();
    private final List<NPC> flowers = new ArrayList<NPC>();
    private NPC lastInteractFlower;
    private final List<NPC> activeFlowers = new ArrayList<NPC>(2);
    private final List<GameObject> saplingIngredients = new ArrayList<GameObject>(5);
    private final GameObject[] saplingOrder = new GameObject[3];
    private NPC foxTrap;
    private final List<GameObject> pheasantNests = new ArrayList<GameObject>(4);
    private NPC freakyForester;
    private NPC unfinishedBeeHive;
    private final List<NPC> circles = new ArrayList<NPC>(5);
    private final List<NPC> entlings = new ArrayList<NPC>(0);
    private final List<TreeRespawn> respawns = new ArrayList<TreeRespawn>();
    private boolean recentlyLoggedIn;
    private int currentPlane;
    private ClueNestTier clueTierSpawned;

    @Provides
    WoodcuttingConfig getConfig(ConfigManager configManager) {
        return configManager.getConfig(WoodcuttingConfig.class);
    }

    @Override
    protected void startUp() throws Exception {
        this.overlayManager.add(this.overlay);
        this.overlayManager.add(this.treesOverlay);
    }

    @Override
    protected void shutDown() throws Exception {
        this.overlayManager.remove(this.overlay);
        this.overlayManager.remove(this.treesOverlay);
        this.respawns.clear();
        this.treeObjects.clear();
        this.roots.clear();
        this.flowers.clear();
        this.saplingIngredients.clear();
        Arrays.fill(this.saplingOrder, null);
        this.session = null;
        this.clueTierSpawned = null;
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        this.recentlyLoggedIn = false;
        this.clueTierSpawned = null;
        this.currentPlane = this.client.getPlane();
        this.respawns.removeIf(TreeRespawn::isExpired);
        if (this.session == null || this.session.getLastChopping() == null) {
            return;
        }
        if (WOODCUTTING_ANIMS.contains(this.client.getLocalPlayer().getAnimation())) {
            this.session.setLastChopping();
            return;
        }
        Duration statTimeout = Duration.ofMinutes(this.config.statTimeout());
        Duration sinceCut = Duration.between(this.session.getLastChopping(), Instant.now());
        if (sinceCut.compareTo(statTimeout) >= 0) {
            this.session.setActive(false);
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        Matcher matcher;
        if (event.getType() != ChatMessageType.SPAM && event.getType() != ChatMessageType.GAMEMESSAGE && event.getType() != ChatMessageType.MESBOX) {
            return;
        }
        String msg = event.getMessage();
        if (WOOD_CUT_PATTERN.matcher(msg).matches()) {
            if (this.session == null) {
                this.session = new WoodcuttingSession();
            }
            this.session.setLastChopping();
            this.session.incrementLogsCut();
        }
        if ((matcher = ANIMA_BARK_PATTERN.matcher(msg)).matches()) {
            if (this.session == null) {
                this.session = new WoodcuttingSession();
            }
            this.session.setLastChopping();
            int num = Integer.parseInt(matcher.group(1));
            this.session.incrementBark(num);
        }
        if (msg.contains("A bird's nest falls out of the tree") && this.config.showNestNotification()) {
            if (this.clueTierSpawned == null || this.clueTierSpawned.ordinal() >= this.config.clueNestNotifyTier().ordinal()) {
                this.notifier.notify("A bird nest has spawned!");
            }
            this.clueTierSpawned = null;
        }
        if (msg.startsWith("The sapling seems to love")) {
            int ingredientNum;
            int n = msg.contains("first") ? 1 : (msg.contains("second") ? 2 : (ingredientNum = msg.contains("third") ? 3 : -1));
            if (ingredientNum == -1) {
                log.debug("unable to find ingredient index from message: {}", (Object)msg);
                return;
            }
            GameObject ingredientObj = this.saplingIngredients.stream().filter(obj -> msg.contains(this.client.getObjectDefinition(obj.getId()).getName().toLowerCase())).findAny().orElse(null);
            if (ingredientObj == null) {
                log.debug("unable to find ingredient from message: {}", (Object)msg);
                return;
            }
            this.saplingOrder[ingredientNum - 1] = ingredientObj;
        }
        if ((msg.equals("There are no open, unpollinated flowers on this bush yet.") || msg.equals("The flowers on this bush have not yet opened enough to harvest pollen.") || msg.equals("<col=06600c>The bush is already fruiting and won't benefit from <col=06600c>any more pollen.</col>")) && this.activeFlowers.contains(this.lastInteractFlower)) {
            log.debug("Flowers reset");
            this.activeFlowers.clear();
        }
    }

    @Subscribe
    public void onItemSpawned(ItemSpawned itemSpawned) {
        if (this.clueTierSpawned == null) {
            this.clueTierSpawned = ClueNestTier.getTierFromItem(itemSpawned.getItem().getId());
        }
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned event) {
        GameObject gameObject = event.getGameObject();
        Tree tree = Tree.findTree(gameObject.getId());
        if (tree == Tree.REDWOOD) {
            this.treeObjects.add(gameObject);
        }
        switch (gameObject.getId()) {
            case 47482: 
            case 47483: {
                if (this.roots.isEmpty() && this.config.forestryRisingRootsNotification()) {
                    this.notifier.notify("A Rising Roots Forestry event spawned!");
                }
                this.roots.add(gameObject);
                break;
            }
            case 47484: 
            case 47485: 
            case 47487: 
            case 47488: 
            case 47490: 
            case 47491: {
                if (!this.config.forestryStrugglingSaplingNotification()) break;
                this.notifier.notify("A Struggling Sapling Forestry event spawned!");
                break;
            }
            case 47493: 
            case 47494: 
            case 47495: 
            case 47496: 
            case 47497: 
            case 47498: 
            case 47499: {
                this.saplingIngredients.add(gameObject);
                break;
            }
            case 49936: 
            case 49937: {
                this.pheasantNests.add(gameObject);
            }
        }
    }

    @Subscribe
    public void onGameObjectDespawned(GameObjectDespawned event) {
        GameObject object = event.getGameObject();
        Tree tree = Tree.findTree(object.getId());
        if (tree != null) {
            if (tree.getRespawnTime() != null && !this.recentlyLoggedIn && this.currentPlane == object.getPlane()) {
                log.debug("Adding respawn timer for {} tree at {}", (Object)tree, (Object)object.getLocalLocation());
                Point min2 = object.getSceneMinLocation();
                WorldPoint base = WorldPoint.fromScene(this.client, min2.getX(), min2.getY(), this.client.getPlane());
                TreeRespawn treeRespawn = new TreeRespawn(tree, object.sizeX() - 1, object.sizeY() - 1, base, Instant.now(), (int)tree.getRespawnTime(base.getRegionID()).toMillis());
                this.respawns.add(treeRespawn);
            }
            if (tree == Tree.REDWOOD) {
                this.treeObjects.remove(event.getGameObject());
            }
        }
        switch (object.getId()) {
            case 47482: 
            case 47483: {
                this.roots.remove(object);
                break;
            }
            case 47493: 
            case 47494: 
            case 47495: 
            case 47496: 
            case 47497: 
            case 47498: 
            case 47499: {
                this.saplingIngredients.remove(object);
                if (!this.saplingIngredients.isEmpty()) break;
                Arrays.fill(this.saplingOrder, null);
                log.debug("Struggling Sapling event is over");
                break;
            }
            case 49936: 
            case 49937: {
                this.pheasantNests.remove(object);
                if (!this.pheasantNests.isEmpty()) break;
                log.debug("Pheasant event is over");
            }
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        switch (event.getGameState()) {
            case LOGIN_SCREEN: 
            case HOPPING: {
                this.respawns.clear();
                this.flowers.clear();
                this.activeFlowers.clear();
                this.foxTrap = null;
                this.freakyForester = null;
                this.unfinishedBeeHive = null;
                this.circles.clear();
                this.entlings.clear();
            }
            case LOADING: {
                this.treeObjects.clear();
                this.roots.clear();
                this.saplingIngredients.clear();
                Arrays.fill(this.saplingOrder, null);
                this.pheasantNests.clear();
                break;
            }
            case LOGGED_IN: {
                this.recentlyLoggedIn = true;
            }
        }
    }

    @Subscribe
    public void onAnimationChanged(AnimationChanged event) {
        NPC flower;
        Actor actor = event.getActor();
        if (actor.getAnimation() == 832 && this.flowers.contains(actor.getInteracting()) && !this.activeFlowers.contains(flower = (NPC)actor.getInteracting())) {
            if (this.activeFlowers.size() == 2) {
                log.debug("Flowers reset");
                this.activeFlowers.clear();
            }
            log.debug("Tracked flower {}", (Object)flower);
            this.activeFlowers.add(flower);
        }
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned event) {
        NPC npc = event.getNpc();
        int id = npc.getId();
        if (WoodcuttingPlugin.isFloweringBush(id)) {
            if (this.flowers.isEmpty() && this.config.forestryFloweringTreeNotification()) {
                this.notifier.notify("A Flowering Tree Forestry event spawned!");
            }
            this.flowers.add(npc);
        } else if (id == 12163 && this.config.forestryLeprechaunNotification()) {
            this.notifier.notify("A Leprechaun event spawned!");
        } else if ((id == 12559 || id == 12560) && this.config.forestryPoachersNotification()) {
            this.notifier.notify("A Poachers event spawned!");
        } else if (id == 12541) {
            this.foxTrap = npc;
        } else if (id == 12536) {
            this.freakyForester = npc;
            if (this.config.forestryPheasantControlNotification()) {
                this.notifier.notify("A Pheasant Control event has spawned!");
            }
        } else if (id == 12518) {
            if (this.config.forestryBeeHiveNotification()) {
                this.notifier.notify("A Bee Hive event has spawned!");
            }
        } else if (id == 12515 || id == 12516) {
            this.unfinishedBeeHive = npc;
        } else if (id >= 12520 && id <= 12535) {
            this.circles.add(npc);
        } else if (id == 12519) {
            if (this.config.forestryEnchantmentRitualNotification()) {
                this.notifier.notify("An Enchantment Ritual event has spawned!");
            }
        } else if (id == 12543) {
            this.entlings.add(npc);
            if (this.entlings.size() == 1 && this.config.forestryFriendlyEntNotification()) {
                this.notifier.notify("A Friendly Ent event has spawned!");
            }
        }
    }

    @Subscribe
    public void onNpcDespawned(NpcDespawned event) {
        NPC npc = event.getNpc();
        if (this.flowers.remove(npc)) {
            if (this.activeFlowers.remove(npc)) {
                this.activeFlowers.clear();
            }
            if (npc == this.lastInteractFlower) {
                this.lastInteractFlower = null;
            }
        }
        if (this.foxTrap == npc) {
            this.foxTrap = null;
        }
        if (this.freakyForester == npc) {
            this.freakyForester = null;
        }
        if (this.unfinishedBeeHive == npc) {
            this.unfinishedBeeHive = null;
        }
        this.circles.remove(npc);
        this.entlings.remove(npc);
    }

    @Subscribe
    public void onInteractingChanged(InteractingChanged event) {
        if (event.getSource() != this.client.getLocalPlayer() || !(event.getTarget() instanceof NPC) || !WoodcuttingPlugin.isFloweringBush(((NPC)event.getTarget()).getId())) {
            return;
        }
        this.lastInteractFlower = (NPC)event.getTarget();
    }

    private static boolean isFloweringBush(int npcId) {
        return npcId == 12120 || npcId == 12134 || npcId == 12141 || npcId == 12143 || npcId == 12145 || npcId == 12147 || npcId == 12149 || npcId == 12151;
    }

    NPC solveCircles() {
        int id;
        int color;
        int shape;
        int off;
        if (this.circles.size() != 5) {
            return null;
        }
        int s2 = 0;
        for (NPC npc : this.circles) {
            off = npc.getId() - 12520;
            shape = off / 4;
            color = off % 4;
            id = 16 << shape | 1 << color;
            s2 ^= id;
        }
        for (NPC npc : this.circles) {
            off = npc.getId() - 12520;
            shape = off / 4;
            id = 16 << shape | 1 << (color = off % 4);
            if ((id & s2) != id) continue;
            return npc;
        }
        return null;
    }

    @Nullable
    public WoodcuttingSession getSession() {
        return this.session;
    }

    void setSession(@Nullable WoodcuttingSession session) {
        this.session = session;
    }

    public Set<GameObject> getTreeObjects() {
        return this.treeObjects;
    }

    List<GameObject> getRoots() {
        return this.roots;
    }

    List<NPC> getFlowers() {
        return this.flowers;
    }

    List<NPC> getActiveFlowers() {
        return this.activeFlowers;
    }

    List<GameObject> getSaplingIngredients() {
        return this.saplingIngredients;
    }

    GameObject[] getSaplingOrder() {
        return this.saplingOrder;
    }

    NPC getFoxTrap() {
        return this.foxTrap;
    }

    List<GameObject> getPheasantNests() {
        return this.pheasantNests;
    }

    NPC getFreakyForester() {
        return this.freakyForester;
    }

    NPC getUnfinishedBeeHive() {
        return this.unfinishedBeeHive;
    }

    List<TreeRespawn> getRespawns() {
        return this.respawns;
    }
}

