/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.specialcounter;

import java.util.function.Function;
import net.runelite.client.plugins.specialcounter.SpecialCounterConfig;

public enum SpecialWeapon {
    DRAGON_WARHAMMER("Dragon Warhammer", new int[]{13576, 28035}, false, SpecialCounterConfig::dragonWarhammerThreshold),
    ARCLIGHT("Arclight", new int[]{19675}, false, SpecialCounterConfig::arclightThreshold),
    DARKLIGHT("Darklight", new int[]{6746}, false, SpecialCounterConfig::darklightThreshold),
    BANDOS_GODSWORD("Bandos Godsword", new int[]{11804, 20370}, true, SpecialCounterConfig::bandosGodswordThreshold),
    BARRELCHEST_ANCHOR("Barrelchest Anchor", new int[]{10887}, true, c -> 0),
    BONE_DAGGER("Bone Dagger", new int[]{8872, 8874, 8876, 8878}, true, c -> 0),
    DORGESHUUN_CROSSBOW("Dorgeshuun Crossbow", new int[]{8880}, true, distance -> 60 + distance * 3, c -> 0),
    BULWARK("Dinh's Bulwark", new int[]{21015}, false, SpecialCounterConfig::bulwarkThreshold),
    ACCURSED_SCEPTRE("Accursed Sceptre", new int[]{27665, 27679}, false, distance -> 46 + distance * 10, c -> 0);

    private final String name;
    private final int[] itemID;
    private final boolean damage;
    private final Function<Integer, Integer> clientCycleHitDelay;
    private final Function<SpecialCounterConfig, Integer> threshold;

    private SpecialWeapon(String name, int[] itemID, boolean damage, Function<SpecialCounterConfig, Integer> threshold) {
        this(name, itemID, damage, distance -> 0, threshold);
    }

    public int getHitDelay(int distance) {
        int serverCyclesDelay = this.getClientCycleHitDelay().apply(distance) / 30;
        return serverCyclesDelay + 1;
    }

    private SpecialWeapon(String name, int[] itemID, boolean damage, Function<Integer, Integer> clientCycleHitDelay, Function<SpecialCounterConfig, Integer> threshold) {
        this.name = name;
        this.itemID = itemID;
        this.damage = damage;
        this.clientCycleHitDelay = clientCycleHitDelay;
        this.threshold = threshold;
    }

    public String getName() {
        return this.name;
    }

    public int[] getItemID() {
        return this.itemID;
    }

    public boolean isDamage() {
        return this.damage;
    }

    public Function<Integer, Integer> getClientCycleHitDelay() {
        return this.clientCycleHitDelay;
    }

    public Function<SpecialCounterConfig, Integer> getThreshold() {
        return this.threshold;
    }
}

