/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.ruler;

import com.google.common.collect.ImmutableList;
import com.google.inject.Provides;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.widgets.Widget;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.input.KeyManager;
import net.runelite.client.input.MouseManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.ruler.RulerConfig;
import net.runelite.client.plugins.ruler.RulerKeyListener;
import net.runelite.client.plugins.ruler.RulerLine;
import net.runelite.client.plugins.ruler.RulerMouseListener;
import net.runelite.client.plugins.ruler.RulerOverlay;
import net.runelite.client.plugins.ruler.RulerPanel;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.overlay.OverlayManager;

@PluginDescriptor(name="Ruler", description="Draw measurement lines on widgets or anywhere on screen to get dx, dy, and pixel distance", tags={"measure", "distance", "widget", "overlay"}, enabledByDefault=false)
public class RulerPlugin
extends Plugin {
    private static final AtomicLong NEXT_ID = new AtomicLong(1L);
    @Inject
    private Client client;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private MouseManager mouseManager;
    @Inject
    private KeyManager keyManager;
    @Inject
    private RulerOverlay overlay;
    @Inject
    private RulerMouseListener mouseListener;
    @Inject
    private RulerKeyListener keyListener;
    @Inject
    private RulerConfig config;
    @Inject
    private ConfigManager configManager;
    @Inject
    private ClientThread clientThread;
    private final List<RulerLine> lines = new ArrayList<RulerLine>();
    private final List<RulerLine> undoStack = new ArrayList<RulerLine>();
    private final Map<Integer, Point> widgetOriginsRel = new HashMap<Integer, Point>();
    private RulerLine currentLine;
    private RulerPanel pluginPanel;
    private NavigationButton navButton;
    private Point globalOrigin = null;
    private boolean draggingOrigin = false;
    private Point dragOffset = null;

    @Override
    protected void startUp() {
        this.overlayManager.add(this.overlay);
        this.pluginPanel = new RulerPanel(this, this.config);
        BufferedImage icon = RulerPlugin.createIcon();
        this.navButton = NavigationButton.builder().tooltip("Ruler").icon(icon).priority(5).panel(this.pluginPanel).build();
        this.clientToolbar.addNavigation(this.navButton);
        this.mouseManager.registerMouseListener(this.mouseListener);
        this.keyManager.registerKeyListener(this.keyListener);
    }

    @Override
    protected void shutDown() {
        this.overlayManager.remove(this.overlay);
        this.mouseManager.unregisterMouseListener(this.mouseListener);
        this.keyManager.unregisterKeyListener(this.keyListener);
        if (this.navButton != null) {
            this.clientToolbar.removeNavigation(this.navButton);
            this.navButton = null;
        }
        this.lines.clear();
        this.currentLine = null;
        this.pluginPanel = null;
        this.mouseManager.unregisterMouseListener(this.mouseListener);
    }

    public boolean isDrawing() {
        return this.currentLine != null;
    }

    public void beginLine(Point p) {
        this.currentLine = new RulerLine(NEXT_ID.getAndIncrement(), p, -1, null);
        Point startPoint = new Point(p);
        this.clientThread.invokeLater(() -> {
            Widget w = this.findDeepestWidgetAtClientThread(startPoint);
            if (this.currentLine != null) {
                Rectangle bounds = w != null ? w.getBounds() : null;
                int widgetId = w != null ? w.getId() : -1;
                this.currentLine.setWidgetContext(widgetId, bounds);
            }
        });
    }

    public void updateCurrentLine(Point p) {
        if (this.currentLine == null) {
            return;
        }
        this.currentLine.setEnd(new Point(p));
        if (this.currentLine.getWidgetBounds() != null) {
            Rectangle b = this.currentLine.getWidgetBounds();
            this.currentLine.setEndRel(new Point(p.x - b.x, p.y - b.y));
        }
    }

    public void finishLine(Point p) {
        if (this.currentLine == null) {
            return;
        }
        this.updateCurrentLine(p);
        this.lines.add(this.currentLine);
        this.undoStack.clear();
        if (this.config.mathMode()) {
            this.copyCS2ToClipboard(this.currentLine);
        }
        this.currentLine = null;
        if (this.pluginPanel != null) {
            this.pluginPanel.rebuild();
        }
    }

    public void deleteLine(RulerLine line) {
        this.lines.remove(line);
        if (this.pluginPanel != null) {
            this.pluginPanel.rebuild();
        }
    }

    public void clearLines() {
        this.lines.clear();
        this.undoStack.clear();
        if (this.pluginPanel != null) {
            this.pluginPanel.rebuild();
        }
    }

    public void undo() {
        if (!this.lines.isEmpty()) {
            RulerLine removed = this.lines.remove(this.lines.size() - 1);
            this.undoStack.add(removed);
            if (this.pluginPanel != null) {
                this.pluginPanel.rebuild();
            }
        }
    }

    public void redo() {
        if (!this.undoStack.isEmpty()) {
            RulerLine restored = this.undoStack.remove(this.undoStack.size() - 1);
            this.lines.add(restored);
            if (this.pluginPanel != null) {
                this.pluginPanel.rebuild();
            }
        }
    }

    public List<RulerLine> getLinesSnapshot() {
        if (this.lines.isEmpty()) {
            return Collections.emptyList();
        }
        return ImmutableList.copyOf(this.lines);
    }

    public void setWidgetOriginAt(Point screenPoint) {
        Point p = new Point(screenPoint);
        this.clientThread.invokeLater(() -> {
            Widget w = this.findDeepestWidgetAtClientThread(p);
            if (w != null && w.getBounds() != null) {
                Rectangle b = w.getBounds();
                Point rel = new Point(p.x - b.x, p.y - b.y);
                this.widgetOriginsRel.put(w.getId(), rel);
                if (this.pluginPanel != null) {
                    this.pluginPanel.rebuild();
                }
            }
        });
    }

    public Point getWidgetOriginRel(int widgetId) {
        return this.widgetOriginsRel.get(widgetId);
    }

    public void setGlobalOrigin(Point p) {
        Point point = this.globalOrigin = p == null ? null : new Point(p);
        if (p != null) {
            this.setUseGlobalOrigin(true);
        }
        if (this.pluginPanel != null) {
            this.pluginPanel.rebuild();
        }
    }

    public void clearGlobalOrigin() {
        this.globalOrigin = null;
        this.setUseGlobalOrigin(false);
        if (this.pluginPanel != null) {
            this.pluginPanel.rebuild();
        }
    }

    public boolean isNearGlobalOrigin(Point p) {
        if (this.globalOrigin == null || !this.config.useGlobalOrigin()) {
            return false;
        }
        int dx = p.x - this.globalOrigin.x;
        int dy = p.y - this.globalOrigin.y;
        return Math.hypot(dx, dy) < 10.0;
    }

    public void startDraggingOrigin(Point mousePos) {
        if (this.globalOrigin != null) {
            this.draggingOrigin = true;
            this.dragOffset = new Point(mousePos.x - this.globalOrigin.x, mousePos.y - this.globalOrigin.y);
        }
    }

    public void updateDraggingOrigin(Point mousePos) {
        if (this.draggingOrigin && this.dragOffset != null) {
            this.globalOrigin = new Point(mousePos.x - this.dragOffset.x, mousePos.y - this.dragOffset.y);
        }
    }

    public void stopDraggingOrigin() {
        this.draggingOrigin = false;
        this.dragOffset = null;
        if (this.pluginPanel != null) {
            this.pluginPanel.rebuild();
        }
    }

    public boolean isDraggingOrigin() {
        return this.draggingOrigin;
    }

    @Provides
    RulerConfig getConfig(ConfigManager configManager) {
        return configManager.getConfig(RulerConfig.class);
    }

    public void setShowEndpointLabels(boolean v) {
        this.configManager.setConfiguration("ruler", "showEndpointLabels", v);
    }

    public void setShowCenterMetrics(boolean v) {
        this.configManager.setConfiguration("ruler", "showCenterMetrics", v);
    }

    public void setUseGlobalOrigin(boolean v) {
        this.configManager.setConfiguration("ruler", "useGlobalOrigin", v);
        if (this.pluginPanel != null) {
            this.pluginPanel.rebuild();
        }
    }

    public void setUseRelativeMode(boolean v) {
        this.configManager.setConfiguration("ruler", "useRelativeMode", v);
        if (this.pluginPanel != null) {
            this.pluginPanel.rebuild();
        }
    }

    public void setMathMode(boolean v) {
        this.configManager.setConfiguration("ruler", "mathMode", v);
    }

    public void setShowOriginMarker(boolean v) {
        this.configManager.setConfiguration("ruler", "showOriginMarker", v);
    }

    private void copyCS2ToClipboard(RulerLine line) {
        int endY;
        int endX;
        int startY;
        int startX;
        Point start = line.getStart();
        Point end = line.getEnd();
        if (this.config.useRelativeMode()) {
            startX = 0;
            startY = 0;
            endX = end.x - start.x;
            endY = end.y - start.y;
        } else if (this.globalOrigin != null) {
            startX = start.x - this.globalOrigin.x;
            startY = start.y - this.globalOrigin.y;
            endX = end.x - this.globalOrigin.x;
            endY = end.y - this.globalOrigin.y;
        } else {
            startX = start.x;
            startY = start.y;
            endX = end.x;
            endY = end.y;
        }
        int midpointX = (int)Math.round((double)(startX + endX) / 2.0);
        int midpointY = (int)Math.round((double)(startY + endY) / 2.0);
        int width = endX - startX;
        int height = endY - startY;
        String cs2Code = String.format("CHILD.setPosition(%d, %d, 1, 1);\nCHILD.setSize(%d, %d, 0, 0);", midpointX, midpointY, width, height);
        try {
            StringSelection selection = new StringSelection(cs2Code);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(selection, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public RulerLine getCurrentLine() {
        return this.currentLine;
    }

    private Widget findDeepestWidgetAt(Point p) {
        Widget[] roots = this.client.getWidgetRoots();
        if (roots == null) {
            return null;
        }
        Widget best = null;
        for (Widget root : roots) {
            Widget w = this.findInTree(root, p);
            if (w == null) continue;
            best = w;
        }
        return best;
    }

    private Widget findInTree(Widget w, Point p) {
        Widget[] stat;
        if (w == null) {
            return null;
        }
        Rectangle b = w.getBounds();
        if (b == null || !b.contains(p)) {
            return null;
        }
        Widget found = w;
        Widget[] dyn = w.getDynamicChildren();
        if (dyn != null) {
            for (Widget c : dyn) {
                Widget r = this.findInTree(c, p);
                if (r == null) continue;
                found = r;
            }
        }
        if ((stat = w.getStaticChildren()) != null) {
            for (Widget c : stat) {
                Widget r = this.findInTree(c, p);
                if (r == null) continue;
                found = r;
            }
        }
        return found;
    }

    private Widget findDeepestWidgetAtClientThread(Point p) {
        Widget[] roots = this.client.getWidgetRoots();
        if (roots == null) {
            return null;
        }
        Widget best = null;
        for (Widget root : roots) {
            Widget w = this.findInTreeClientThread(root, p);
            if (w == null) continue;
            best = w;
        }
        return best;
    }

    private Widget findInTreeClientThread(Widget w, Point p) {
        Widget[] nested;
        Widget[] stat;
        if (w == null) {
            return null;
        }
        Rectangle b = w.getBounds();
        if (b == null || !b.contains(p)) {
            return null;
        }
        Widget found = w;
        Widget[] dyn = w.getDynamicChildren();
        if (dyn != null) {
            for (Widget c : dyn) {
                Widget r = this.findInTreeClientThread(c, p);
                if (r == null) continue;
                found = r;
            }
        }
        if ((stat = w.getStaticChildren()) != null) {
            for (Widget c : stat) {
                Widget r = this.findInTreeClientThread(c, p);
                if (r == null) continue;
                found = r;
            }
        }
        if ((nested = w.getNestedChildren()) != null) {
            for (Widget c : nested) {
                Widget r = this.findInTreeClientThread(c, p);
                if (r == null) continue;
                found = r;
            }
        }
        return found;
    }

    private static BufferedImage createIcon() {
        BufferedImage img = new BufferedImage(16, 16, 2);
        Graphics2D g2 = img.createGraphics();
        g2.setColor(new Color(0, 200, 255, 220));
        g2.setStroke(new BasicStroke(2.0f));
        g2.drawLine(2, 13, 13, 2);
        g2.drawLine(2, 8, 8, 8);
        g2.dispose();
        return img;
    }

    public List<RulerLine> getLines() {
        return this.lines;
    }

    public Point getGlobalOrigin() {
        return this.globalOrigin;
    }
}

