/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.ruler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.util.List;
import javax.inject.Inject;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.runelite.client.plugins.ruler.RulerConfig;
import net.runelite.client.plugins.ruler.RulerLine;
import net.runelite.client.plugins.ruler.RulerPlugin;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.PluginPanel;

public class RulerPanel
extends PluginPanel {
    private final RulerPlugin plugin;
    private final RulerConfig config;
    private final JCheckBox showLabels;
    private final JCheckBox showCenter;
    private final JCheckBox useGlobalOrigin;
    private final JCheckBox useRelativeMode;
    private final JCheckBox showOriginMarker;
    private final JCheckBox mathMode;
    private final JPanel listPanel;

    @Inject
    public RulerPanel(RulerPlugin plugin, RulerConfig config) {
        this.plugin = plugin;
        this.config = config;
        this.setLayout(new BorderLayout());
        JPanel top = new JPanel(new GridBagLayout());
        top.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(6, 6, 6, 6);
        top.add((Component)new JLabel("Ruler"), c);
        ++c.gridy;
        this.showLabels = new JCheckBox("Show endpoint labels", config.showEndpointLabels());
        this.showLabels.addActionListener(e -> plugin.setShowEndpointLabels(this.showLabels.isSelected()));
        top.add((Component)this.showLabels, c);
        ++c.gridy;
        this.showCenter = new JCheckBox("Show deltas/distance", config.showCenterMetrics());
        this.showCenter.addActionListener(e -> plugin.setShowCenterMetrics(this.showCenter.isSelected()));
        top.add((Component)this.showCenter, c);
        ++c.gridy;
        this.useGlobalOrigin = new JCheckBox("Use global origin", config.useGlobalOrigin());
        top.add((Component)this.useGlobalOrigin, c);
        ++c.gridy;
        this.useRelativeMode = new JCheckBox("Relative mode", config.useRelativeMode());
        top.add((Component)this.useRelativeMode, c);
        this.useGlobalOrigin.addActionListener(e -> {
            plugin.setUseGlobalOrigin(this.useGlobalOrigin.isSelected());
            if (this.useGlobalOrigin.isSelected() && this.useRelativeMode.isSelected()) {
                this.useRelativeMode.setSelected(false);
                plugin.setUseRelativeMode(false);
            }
        });
        this.useRelativeMode.addActionListener(e -> {
            plugin.setUseRelativeMode(this.useRelativeMode.isSelected());
            if (this.useRelativeMode.isSelected() && this.useGlobalOrigin.isSelected()) {
                this.useGlobalOrigin.setSelected(false);
                plugin.setUseGlobalOrigin(false);
            }
        });
        ++c.gridy;
        this.showOriginMarker = new JCheckBox("Show origin marker", config.showOriginMarker());
        this.showOriginMarker.addActionListener(e -> plugin.setShowOriginMarker(this.showOriginMarker.isSelected()));
        top.add((Component)this.showOriginMarker, c);
        ++c.gridy;
        this.mathMode = new JCheckBox("Math mode (CS2)", config.mathMode());
        this.mathMode.addActionListener(e -> plugin.setMathMode(this.mathMode.isSelected()));
        top.add((Component)this.mathMode, c);
        ++c.gridy;
        JButton setOrigin = new JButton("Set Origin (Ctrl+Shift+RClick)");
        setOrigin.addActionListener(e -> {});
        setOrigin.setEnabled(false);
        setOrigin.setToolTipText("Ctrl+Shift+Right-click on canvas to set global origin");
        top.add((Component)setOrigin, c);
        ++c.gridy;
        JButton clearOrigin = new JButton("Clear Origin");
        clearOrigin.addActionListener(e -> plugin.clearGlobalOrigin());
        top.add((Component)clearOrigin, c);
        ++c.gridy;
        JButton clear = new JButton("Clear all lines");
        clear.addActionListener(e -> plugin.clearLines());
        top.add((Component)clear, c);
        this.add((Component)top, "North");
        this.listPanel = new JPanel(new GridBagLayout());
        this.listPanel.setBackground(ColorScheme.DARK_GRAY_COLOR);
        JScrollPane scroll = new JScrollPane(this.listPanel);
        this.add((Component)scroll, "Center");
    }

    public void rebuild() {
        this.useGlobalOrigin.setSelected(this.config.useGlobalOrigin());
        this.useRelativeMode.setSelected(this.config.useRelativeMode());
        this.showOriginMarker.setSelected(this.config.showOriginMarker());
        this.mathMode.setSelected(this.config.mathMode());
        this.showLabels.setSelected(this.config.showEndpointLabels());
        this.showCenter.setSelected(this.config.showCenterMetrics());
        this.listPanel.removeAll();
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(4, 6, 4, 6);
        c.anchor = 18;
        List<RulerLine> lines = this.plugin.getLinesSnapshot();
        for (RulerLine line : lines) {
            JPanel row = this.lineRow(line);
            this.listPanel.add((Component)row, c);
            ++c.gridy;
        }
        c.weighty = 1.0;
        c.fill = 3;
        this.listPanel.add(Box.createVerticalGlue(), c);
        this.listPanel.revalidate();
        this.listPanel.repaint();
    }

    private JPanel lineRow(RulerLine line) {
        int ax;
        int dy;
        int dx;
        String b;
        String a;
        JPanel row = new JPanel(new GridBagLayout());
        row.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(2, 2, 2, 8);
        c.anchor = 17;
        if (this.config.useRelativeMode()) {
            a = "(0,0)";
            int bx = line.dx();
            int by = -line.dy();
            b = String.format("(%d,%d)", bx, by);
            dx = bx;
            dy = by;
        } else if (this.config.useGlobalOrigin() && this.plugin.getGlobalOrigin() != null) {
            Point origin = this.plugin.getGlobalOrigin();
            ax = line.getStart().x - origin.x;
            int ay = -(line.getStart().y - origin.y);
            int bx = line.getEnd().x - origin.x;
            int by = -(line.getEnd().y - origin.y);
            a = String.format("(%d,%d)", ax, ay);
            b = String.format("(%d,%d)", bx, by);
            dx = bx - ax;
            dy = by - ay;
        } else if (line.getWidgetId() != -1 && line.getStartRel() != null && line.getEndRel() != null) {
            Point origin = this.plugin.getWidgetOriginRel(line.getWidgetId());
            if (origin != null) {
                ax = line.getStartRel().x - origin.x;
                int ay = -(line.getStartRel().y - origin.y);
                int bx = line.getEndRel().x - origin.x;
                int by = -(line.getEndRel().y - origin.y);
                a = String.format("(%d,%d)", ax, ay);
                b = String.format("(%d,%d)", bx, by);
                dx = bx - ax;
                dy = by - ay;
            } else {
                a = String.format("(%d,%d)", line.getStartRel().x, line.getStartRel().y);
                b = String.format("(%d,%d)", line.getEndRel().x, line.getEndRel().y);
                dx = line.dx();
                dy = line.dy();
            }
        } else {
            a = String.format("[%d,%d]", line.getStart().x, line.getStart().y);
            b = String.format("[%d,%d]", line.getEnd().x, line.getEnd().y);
            dx = line.dx();
            dy = line.dy();
        }
        String metrics = String.format("dx=%d dy=%d |d|=%d", dx, dy, (int)Math.round(line.length()));
        row.add((Component)new JLabel(a + " \u2192 " + b + "  " + metrics), c);
        ++c.gridx;
        JButton del = new JButton("Delete");
        del.addActionListener(e -> this.plugin.deleteLine(line));
        row.add((Component)del, c);
        return row;
    }
}

