/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.ruler;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.client.plugins.ruler.RulerConfig;
import net.runelite.client.plugins.ruler.RulerLine;
import net.runelite.client.plugins.ruler.RulerPlugin;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;

@Singleton
public class RulerOverlay
extends Overlay {
    private static final Color LINE_COLOR = new Color(0, 200, 255, 220);
    private static final Color POINT_FILL = new Color(0, 200, 255, 160);
    private static final Color TEXT_COLOR = Color.WHITE;
    private static final Color MATH_MODE_COLOR = new Color(255, 50, 50, 255);
    private static final Color ORIGIN_OUTER = new Color(0, 255, 0, 255);
    private static final Color ORIGIN_INNER = new Color(255, 0, 0, 255);
    private static final int POINT_RADIUS = 3;
    private static final int ORIGIN_OUTER_RADIUS = 10;
    private static final int ORIGIN_INNER_RADIUS = 2;
    private final RulerPlugin plugin;
    private final RulerConfig config;

    @Inject
    public RulerOverlay(RulerPlugin plugin, RulerConfig config) {
        this.plugin = plugin;
        this.config = config;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.HIGHEST);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
        this.drawAfterInterface(165);
    }

    @Override
    public Dimension render(Graphics2D g2) {
        boolean hasContent;
        List<RulerLine> lines = this.plugin.getLinesSnapshot();
        Point globalOrigin = this.plugin.getGlobalOrigin();
        boolean bl = hasContent = !lines.isEmpty() || this.plugin.getCurrentLine() != null || globalOrigin != null && this.config.showOriginMarker();
        if (!hasContent) {
            return null;
        }
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setStroke(new BasicStroke(2.0f));
        g2.setFont(FontManager.getRunescapeSmallFont());
        if (globalOrigin != null && this.config.showOriginMarker()) {
            this.drawOriginMarker(g2, globalOrigin);
        }
        for (RulerLine line : lines) {
            this.drawLine(g2, line);
        }
        RulerLine cur = this.plugin.getCurrentLine();
        if (cur != null) {
            this.drawLine(g2, cur);
        }
        return null;
    }

    private void drawLine(Graphics2D g2, RulerLine line) {
        Point a = line.getStart();
        Point b = line.getEnd();
        g2.setColor(LINE_COLOR);
        g2.draw(new Line2D.Float(a.x, a.y, b.x, b.y));
        g2.setColor(POINT_FILL);
        g2.fillOval(a.x - 3, a.y - 3, 6, 6);
        g2.fillOval(b.x - 3, b.y - 3, 6, 6);
        if (this.config.showEndpointLabels()) {
            g2.setColor(TEXT_COLOR);
            String aLabel = this.endpointLabel(line, true);
            String bLabel = this.endpointLabel(line, false);
            g2.drawString(aLabel, a.x + 6, a.y - 6);
            g2.drawString(bLabel, b.x + 6, b.y - 6);
        }
        if (this.config.showCenterMetrics()) {
            int dy;
            int dx;
            int cx = (a.x + b.x) / 2;
            int cy = (a.y + b.y) / 2;
            if (this.config.useRelativeMode()) {
                dx = line.dx();
                dy = -line.dy();
            } else if (this.config.useGlobalOrigin() && this.plugin.getGlobalOrigin() != null) {
                Point origin = this.plugin.getGlobalOrigin();
                dx = b.x - origin.x;
                dy = -(b.y - origin.y);
            } else if (line.getWidgetId() != -1 && line.getStartRel() != null && line.getEndRel() != null && this.plugin.getWidgetOriginRel(line.getWidgetId()) != null) {
                dx = line.getEndRel().x - line.getStartRel().x;
                dy = -(line.getEndRel().y - line.getStartRel().y);
            } else {
                dx = line.dx();
                dy = line.dy();
            }
            int dist = (int)Math.round(line.length());
            if (this.config.mathMode()) {
                int endY;
                int endX;
                int startY;
                int startX;
                Point start = line.getStart();
                Point end = line.getEnd();
                if (this.config.useRelativeMode()) {
                    startX = 0;
                    startY = 0;
                    endX = end.x - start.x;
                    endY = end.y - start.y;
                } else if (this.plugin.getGlobalOrigin() != null) {
                    Point origin = this.plugin.getGlobalOrigin();
                    startX = start.x - origin.x;
                    startY = start.y - origin.y;
                    endX = end.x - origin.x;
                    endY = end.y - origin.y;
                } else {
                    startX = start.x;
                    startY = start.y;
                    endX = end.x;
                    endY = end.y;
                }
                int midpointX = (int)Math.round((double)(startX + endX) / 2.0);
                int midpointY = (int)Math.round((double)(startY + endY) / 2.0);
                int width = endX - startX;
                int height = endY - startY;
                g2.setColor(MATH_MODE_COLOR);
                String mathLine1 = String.format("setPosition(%d, %d, 1, 1)", midpointX, midpointY);
                String mathLine2 = String.format("setSize(%d, %d, 0, 0)", width, height);
                g2.drawString(mathLine1, cx + 8, cy + 14);
                g2.drawString(mathLine2, cx + 8, cy + 28);
            } else {
                String mid = String.format("dx=%d, dy=%d, |d|=%d", dx, dy, dist);
                g2.setColor(TEXT_COLOR);
                g2.drawString(mid, cx + 8, cy + 14);
            }
        }
    }

    private String endpointLabel(RulerLine line, boolean start) {
        Point p;
        Point point = p = start ? line.getStart() : line.getEnd();
        if (this.config.useRelativeMode()) {
            int rx = p.x - line.getStart().x;
            int ry = -(p.y - line.getStart().y);
            return String.format("(%d,%d)", rx, ry);
        }
        if (this.plugin.getGlobalOrigin() != null) {
            Point origin = this.plugin.getGlobalOrigin();
            int gx = p.x - origin.x;
            int gy = -(p.y - origin.y);
            return String.format("(%d,%d)", gx, gy);
        }
        if (line.getWidgetId() != -1 && line.getWidgetBounds() != null) {
            Point pRel;
            Point point2 = pRel = start ? line.getStartRel() : line.getEndRel();
            if (pRel != null) {
                Point origin = this.plugin.getWidgetOriginRel(line.getWidgetId());
                if (origin != null) {
                    int gx = pRel.x - origin.x;
                    int gy = -(pRel.y - origin.y);
                    return String.format("(%d,%d)", gx, gy);
                }
                return String.format("(%d,%d)", pRel.x, pRel.y);
            }
        }
        return String.format("[%d,%d]", p.x, p.y);
    }

    private void drawOriginMarker(Graphics2D g2, Point origin) {
        g2.setColor(ORIGIN_OUTER);
        g2.fillOval(origin.x - 10, origin.y - 10, 20, 20);
        g2.setColor(ORIGIN_INNER);
        g2.fillOval(origin.x - 2, origin.y - 2, 4, 4);
        if (this.config.showEndpointLabels()) {
            g2.setColor(TEXT_COLOR);
            g2.drawString("(0,0)", origin.x + 12, origin.y - 12);
        }
    }
}

