/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.ruler;

import java.awt.event.MouseEvent;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.SwingUtilities;
import net.runelite.client.input.MouseAdapter;
import net.runelite.client.plugins.ruler.RulerPlugin;

@Singleton
public class RulerMouseListener
extends MouseAdapter {
    private final RulerPlugin plugin;

    @Inject
    public RulerMouseListener(RulerPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public MouseEvent mousePressed(MouseEvent event) {
        if (SwingUtilities.isLeftMouseButton(event) && this.plugin.isNearGlobalOrigin(event.getPoint())) {
            this.plugin.startDraggingOrigin(event.getPoint());
            event.consume();
            return event;
        }
        if (event.isShiftDown()) {
            if (SwingUtilities.isLeftMouseButton(event)) {
                this.plugin.beginLine(event.getPoint());
                event.consume();
            } else if (SwingUtilities.isRightMouseButton(event)) {
                if (event.isControlDown()) {
                    this.plugin.setGlobalOrigin(event.getPoint());
                    event.consume();
                } else {
                    this.plugin.setWidgetOriginAt(event.getPoint());
                    event.consume();
                }
            }
        }
        return event;
    }

    @Override
    public MouseEvent mouseDragged(MouseEvent event) {
        if (this.plugin.isDraggingOrigin()) {
            this.plugin.updateDraggingOrigin(event.getPoint());
            event.consume();
        } else if (this.plugin.isDrawing()) {
            this.plugin.updateCurrentLine(event.getPoint());
            event.consume();
        }
        return event;
    }

    @Override
    public MouseEvent mouseReleased(MouseEvent event) {
        if (this.plugin.isDraggingOrigin() && SwingUtilities.isLeftMouseButton(event)) {
            this.plugin.stopDraggingOrigin();
            event.consume();
        } else if (this.plugin.isDrawing() && SwingUtilities.isLeftMouseButton(event)) {
            this.plugin.finishLine(event.getPoint());
            event.consume();
        }
        return event;
    }
}

