/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.ruler;

import java.awt.Point;
import java.awt.Rectangle;

public class RulerLine {
    private final long id;
    private final Point start;
    private Point end;
    private int widgetId;
    private Rectangle widgetBounds;
    private Point startRel;
    private Point endRel;

    public RulerLine(long id, Point start, int widgetId, Rectangle widgetBounds) {
        this.id = id;
        this.start = new Point(start);
        this.end = new Point(start);
        this.widgetId = widgetId;
        this.widgetBounds = widgetBounds == null ? null : new Rectangle(widgetBounds);
        Point point = this.startRel = widgetBounds == null ? null : new Point(start.x - widgetBounds.x, start.y - widgetBounds.y);
        this.endRel = widgetBounds == null ? null : new Point(start.x - (widgetBounds == null ? 0 : widgetBounds.x), start.y - (widgetBounds == null ? 0 : widgetBounds.y));
    }

    public int dx() {
        return this.end.x - this.start.x;
    }

    public int dy() {
        return this.end.y - this.start.y;
    }

    public double length() {
        int dx = this.dx();
        int dy = this.dy();
        return Math.hypot(dx, dy);
    }

    public void setWidgetContext(int widgetId, Rectangle widgetBounds) {
        this.widgetId = widgetId;
        if (widgetBounds == null) {
            this.widgetBounds = null;
            this.startRel = null;
            this.endRel = null;
        } else {
            this.widgetBounds = new Rectangle(widgetBounds);
            this.startRel = new Point(this.start.x - widgetBounds.x, this.start.y - widgetBounds.y);
            this.endRel = new Point(this.end.x - widgetBounds.x, this.end.y - widgetBounds.y);
        }
    }

    public long getId() {
        return this.id;
    }

    public Point getStart() {
        return this.start;
    }

    public Point getEnd() {
        return this.end;
    }

    public int getWidgetId() {
        return this.widgetId;
    }

    public Rectangle getWidgetBounds() {
        return this.widgetBounds;
    }

    public Point getStartRel() {
        return this.startRel;
    }

    public Point getEndRel() {
        return this.endRel;
    }

    public void setEnd(Point end) {
        this.end = end;
    }

    public void setEndRel(Point endRel) {
        this.endRel = endRel;
    }
}

