/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.npcspawns;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Provides;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.NPC;
import net.runelite.api.Tile;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.FocusChanged;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.npcspawns.NpcSpawnConfig;
import net.runelite.client.plugins.npcspawns.NpcSpawnsInput;
import net.runelite.client.plugins.npcspawns.NpcSpawnsPanel;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="NPC Spawn Editor", description="Edit NPC spawns", tags={"tool", "spawn", "npcs"}, developerPlugin=false)
@Singleton
public class NpcSpawnsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(NpcSpawnsPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private NpcSpawnsInput inputListener;
    @Inject
    private KeyManager keyManager;
    @Inject
    private NpcSpawnConfig config;
    @Inject
    private EventBus eventbus;
    private NpcSpawnsPanel uiPanel;
    private boolean shiftDown;
    private static final String WALK_HERE = "Walk here";
    private static final String TAG = "Remove NPC";
    private static final String SPAWN = "Spawn NPC";
    private static final Set<MenuAction> NPC_MENU_ACTIONS = ImmutableSet.of(MenuAction.NPC_FIRST_OPTION, MenuAction.NPC_SECOND_OPTION, MenuAction.NPC_THIRD_OPTION, MenuAction.NPC_FOURTH_OPTION, MenuAction.NPC_FIFTH_OPTION);
    private File spawnsFolder;

    @Provides
    NpcSpawnConfig provideConfig(ConfigManager configManager) {
        return configManager.getConfig(NpcSpawnConfig.class);
    }

    @Override
    protected void startUp() throws Exception {
        BufferedImage icon = ImageUtil.getResourceStreamFromClass(this.getClass(), "npc.png");
        this.uiPanel = this.injector.getInstance(NpcSpawnsPanel.class);
        NavigationButton uiNavigationButton = NavigationButton.builder().tooltip("NPC Spawns").icon(icon).priority(6).panel(this.uiPanel).build();
        this.clientToolbar.addNavigation(uiNavigationButton);
        this.updateConfig();
        this.keyManager.registerKeyListener(this.inputListener);
        this.clientThread.invoke(() -> {});
    }

    @Override
    protected void shutDown() throws Exception {
        this.eventbus.unregister(this);
        this.keyManager.unregisterKeyListener(this.inputListener);
    }

    @Subscribe
    private void onConfigChanged(ConfigChanged configChanged) {
        if (!configChanged.getGroup().equals("npcspawneditor")) {
            return;
        }
        this.updateConfig();
    }

    @Subscribe
    private void onFocusChanged(FocusChanged focusChanged) {
        if (!focusChanged.isFocused()) {
            this.shiftDown = false;
        }
    }

    @Subscribe
    private void onMenuEntryAdded(MenuEntryAdded event) {
        int type = event.getType();
        if (type >= 2000) {
            type -= 2000;
        }
        if (this.shiftDown && event.getOption().equals(WALK_HERE)) {
            Tile selectedSceneTile = this.client.getSelectedSceneTile();
            if (selectedSceneTile == null) {
                return;
            }
            Tile tile = this.client.getSelectedSceneTile();
            if (tile == null) {
                return;
            }
            this.client.insertMenuItem(SPAWN, event.getTarget(), MenuAction.RUNELITE.getId(), event.getIdentifier(), event.getActionParam0(), event.getActionParam1(), -1, false);
        } else if (this.shiftDown && type == MenuAction.EXAMINE_NPC.getId()) {
            this.client.insertMenuItem(TAG, event.getTarget(), MenuAction.RUNELITE.getId(), event.getIdentifier(), event.getActionParam0(), event.getActionParam1(), -1, false);
        }
    }

    @Subscribe
    private void onMenuOptionClicked(MenuOptionClicked click) {
        if (click.getMenuAction() == MenuAction.RUNELITE && click.getMenuOption().equals(SPAWN)) {
            Tile target = this.client.getSelectedSceneTile();
            if (target == null) {
                return;
            }
            WorldPoint worldPoint = target.getWorldLocation();
            int npcId = this.uiPanel.getNpcId();
            int walkRange = this.uiPanel.getWalkRange();
            String direction = this.uiPanel.getDirection();
            String command = String.format("::addspawn %d %d %d %d %s", npcId, walkRange, worldPoint.getX(), worldPoint.getY(), direction);
            this.client.addChatMessage(ChatMessageType.CONSOLE, "", command, "RL+");
            this.client.runScript(5517, ChatMessageType.GAMEMESSAGE.getType(), command, -1, 0, -1);
            click.consume();
            return;
        }
        if (click.getMenuAction() == MenuAction.RUNELITE && click.getMenuOption().equals(TAG)) {
            int id = click.getId();
            NPC[] cachedNPCs = this.client.getCachedNPCs();
            NPC npc = cachedNPCs[id];
            if (npc == null) {
                return;
            }
            String command = "::removespawn " + id;
            this.client.runScript(5517, ChatMessageType.GAMEMESSAGE.getType(), command, -1, 0, -1);
            click.consume();
            return;
        }
    }

    private void updateConfig() {
        this.spawnsFolder = new File(this.config.outputLocation());
    }

    void setShiftDown(boolean shiftDown) {
        this.shiftDown = shiftDown;
    }
}

