/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.npcspawns;

import com.google.common.base.Strings;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.runelite.api.Client;
import net.runelite.api.NPCComposition;
import net.runelite.api.coords.Direction;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.plugins.npcspawns.NpcSpawnsPlugin;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.components.ComboBoxListRenderer;
import net.runelite.client.ui.components.IconTextField;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class NpcSpawnsPanel
extends PluginPanel {
    private static final Logger log = LoggerFactory.getLogger(NpcSpawnsPanel.class);
    private final ConfigManager configManager;
    private final ScheduledExecutorService executor;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    private final NpcSpawnsPlugin plugin;
    private final IconTextField searchBar;
    private final JList<SpawnValue> searchResults;
    private final JList<SpawnValue> favourites;
    private final JFormattedTextField spawnIdTextField;
    private final JSpinner walkDistance;
    private final JComboBox<Direction> directionComboBox;
    private boolean loading = false;
    private static final TypeToken<List<SpawnValue>> SPAWN_TYPE = new TypeToken<List<SpawnValue>>(){};
    private static final Gson GSON = new Gson();
    private List<NPCComposition> npcDefs;

    @Inject
    public NpcSpawnsPanel(NpcSpawnsPlugin plugin, Client client, ScheduledExecutorService executor, ConfigManager configManager) {
        this.client = client;
        this.executor = executor;
        this.plugin = plugin;
        this.configManager = configManager;
        log.info("Executor is null? {}", (Object)(executor == null ? 1 : 0));
        this.setBorder(new EmptyBorder(7, 10, 0, 10));
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 20;
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 10, 0);
        JPanel container = new JPanel();
        container.setLayout(new BoxLayout(container, 1));
        JPanel totalPanel = new JPanel();
        totalPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        totalPanel.setLayout(new GridLayout(3, 2));
        totalPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.spawnIdTextField = new JFormattedTextField(NumberFormat.getInstance());
        this.spawnIdTextField.setText("0");
        this.walkDistance = new JSpinner(new SpinnerNumberModel());
        this.directionComboBox = new JComboBox<Direction>(Direction.values());
        ComboBoxListRenderer renderer = new ComboBoxListRenderer();
        this.directionComboBox.setRenderer(renderer);
        totalPanel.add(new JLabel("ID:"));
        totalPanel.add(this.spawnIdTextField);
        totalPanel.add(new JLabel("Range:"));
        totalPanel.add(this.walkDistance);
        totalPanel.add(new JLabel("Face:"));
        totalPanel.add(this.directionComboBox);
        JPanel searchPanel = new JPanel();
        searchPanel.setLayout(new BoxLayout(searchPanel, 1));
        this.searchBar = new IconTextField();
        this.searchBar.setIcon(IconTextField.Icon.SEARCH);
        this.searchBar.setPreferredSize(new Dimension(205, 30));
        this.searchBar.setMaximumSize(new Dimension(1000, 30));
        this.searchBar.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.searchBar.setHoverBackgroundColor(ColorScheme.DARK_GRAY_HOVER_COLOR);
        this.searchBar.setMinimumSize(new Dimension(0, 30));
        this.searchBar.addActionListener(e -> executor.execute(this::lookup));
        this.searchResults = new JList(new DefaultListModel());
        this.searchBar.addClearListener(() -> ((DefaultListModel)this.searchResults.getModel()).clear());
        searchPanel.add(this.searchBar);
        JScrollPane scrollableList = new JScrollPane(this.searchResults);
        scrollableList.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        scrollableList.setBorder(new EmptyBorder(5, 5, 5, 5));
        scrollableList.setPreferredSize(new Dimension(0, 230));
        scrollableList.setAlignmentY(1.0f);
        searchPanel.add(scrollableList);
        this.favourites = new JList(new DefaultListModel());
        scrollableList = new JScrollPane(this.favourites);
        scrollableList.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        scrollableList.setBorder(new EmptyBorder(5, 5, 5, 5));
        scrollableList.setPreferredSize(new Dimension(0, 110));
        scrollableList.setAlignmentY(1.0f);
        searchPanel.add(scrollableList);
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem favItems = new JMenuItem("Add to favourites");
        favItems.addActionListener(evt -> this.addFavourite(this.searchResults.getSelectedValue()));
        popupMenu.add(favItems);
        this.searchResults.setComponentPopupMenu(popupMenu);
        popupMenu = new JPopupMenu();
        JMenuItem unfavItems = new JMenuItem("Remove from favourites");
        unfavItems.addActionListener(evt -> this.removeFavourite(this.favourites.getSelectedValue()));
        popupMenu.add(unfavItems);
        this.favourites.setComponentPopupMenu(popupMenu);
        MouseAdapter adapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    JList list = (JList)e.getSource();
                    int row = list.locationToIndex(e.getPoint());
                    list.setSelectedIndex(row);
                }
            }
        };
        this.favourites.addMouseListener(adapter);
        this.searchResults.addMouseListener(adapter);
        this.searchResults.addListSelectionListener(listener -> {
            try {
                this.spawnIdTextField.setText(Integer.toString(this.searchResults.getSelectedValue().getId()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.favourites.addListSelectionListener(listener -> {
            try {
                this.spawnIdTextField.setText(Integer.toString(this.favourites.getSelectedValue().getId()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        searchPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        searchPanel.setAlignmentY(1.0f);
        container.add(Box.createGlue());
        container.add(totalPanel);
        container.add(Box.createRigidArea(new Dimension(0, 10)));
        container.add(searchPanel);
        container.add(Box.createGlue());
        this.add((Component)container, c);
        this.populateFavourites();
    }

    public void populateFavourites() {
        try {
            String savedJson = this.configManager.getConfiguration("npcSpawns", "favourites");
            if (savedJson != null && !savedJson.isEmpty()) {
                List spawnList = (List)GSON.fromJson(savedJson, SPAWN_TYPE.getType());
                DefaultListModel listModel = (DefaultListModel)this.favourites.getModel();
                spawnList.forEach(listModel::addElement);
            }
        }
        catch (JsonSyntaxException e) {
            e.printStackTrace();
        }
    }

    public void addFavourite(SpawnValue value) {
        try {
            DefaultListModel listModel = (DefaultListModel)this.favourites.getModel();
            listModel.addElement(value);
            this.save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void removeFavourite(SpawnValue value) {
        try {
            DefaultListModel listModel = (DefaultListModel)this.favourites.getModel();
            listModel.removeElement(value);
            this.save();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void save() {
        DefaultListModel listModel = (DefaultListModel)this.favourites.getModel();
        ArrayList values2 = Collections.list(listModel.elements());
        String json = GSON.toJson(values2);
        this.configManager.setConfiguration("npcSpawns", "favourites", json);
        this.configManager.sendConfig();
    }

    @Override
    public void onActivate() {
        super.onActivate();
        this.searchBar.requestFocusInWindow();
    }

    private void lookup() {
        try {
            String lookup;
            if (this.npcDefs == null) {
                this.npcDefs = new ArrayList<NPCComposition>();
                this.clientThread.invoke(() -> {
                    try {
                        for (int i = 0; i < 13000; ++i) {
                            System.out.println("Attempting to find NPC " + i);
                            NPCComposition npcDefinition = this.client.getNpcDefinition(i);
                            if (npcDefinition == null) continue;
                            this.npcDefs.add(npcDefinition);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            }
            if (Strings.isNullOrEmpty(lookup = this.searchBar.getText())) {
                return;
            }
            this.searchBar.setEditable(false);
            this.searchBar.setIcon(IconTextField.Icon.LOADING_DARKER);
            this.loading = true;
            DefaultListModel listModel = (DefaultListModel)this.searchResults.getModel();
            try {
                int searchId = Integer.parseInt(this.searchBar.getText());
                NPCComposition def2 = this.client.getNpcDefinition(searchId);
                this.searchBar.setIcon(IconTextField.Icon.SEARCH);
                this.searchBar.setEditable(true);
                this.loading = false;
                listModel.clear();
                listModel.addElement(new SpawnValue(def2.getId(), def2.getName()));
                return;
            }
            catch (Exception searchId) {
                Predicate<NPCComposition> matchesInput = def -> StringUtils.containsIgnoreCase(def.getName(), lookup);
                List filteredNpcs = this.npcDefs.stream().filter(matchesInput).map(def -> new SpawnValue(def.getId(), def.getName())).collect(Collectors.toList());
                if (filteredNpcs.size() == 0) {
                    this.searchBar.setIcon(IconTextField.Icon.ERROR);
                    this.searchBar.setEditable(true);
                    this.loading = false;
                    listModel.clear();
                    return;
                }
                this.searchBar.setIcon(IconTextField.Icon.SEARCH);
                this.searchBar.setEditable(true);
                this.loading = false;
                listModel.clear();
                filteredNpcs.stream().forEach(listModel::addElement);
            }
        }
        catch (Exception e) {
            this.searchBar.setIcon(IconTextField.Icon.SEARCH);
            this.searchBar.setEditable(true);
            this.loading = false;
            e.printStackTrace();
        }
    }

    public int getNpcId() {
        return Integer.parseInt(this.spawnIdTextField.getText().replace(",", ""));
    }

    public int getWalkRange() {
        return (Integer)this.walkDistance.getValue();
    }

    public String getDirection() {
        return Character.toString(((Direction)((Object)this.directionComboBox.getSelectedItem())).name().toUpperCase().charAt(0));
    }

    void addInputKeyListener(KeyListener l) {
        this.searchBar.addKeyListener(l);
    }

    void removeInputKeyListener(KeyListener l) {
        this.searchBar.removeKeyListener(l);
    }

    private static class SpawnValue {
        final int id;
        final String name;

        public String toString() {
            return this.id + ": " + this.name;
        }

        public SpawnValue(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SpawnValue)) {
                return false;
            }
            SpawnValue other = (SpawnValue)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getId() != other.getId()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SpawnValue;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getId();
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }
    }
}

