/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.info;

import com.google.common.base.MoreObjects;
import com.google.inject.Inject;
import com.openosrs.client.OpenOSRS;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import mapped.util.RSPSConstants;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.World;
import net.runelite.client.RuneLiteProperties;
import net.runelite.client.account.SessionManager;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.SessionClose;
import net.runelite.client.events.SessionOpen;
import net.runelite.client.plugins.info.JRichTextPane;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.LinkBrowser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfoPanel
extends PluginPanel {
    private static final String RUNELITE_LOGIN = "https://runelite_login/";
    private static final ImageIcon ARROW_RIGHT_ICON;
    private static final ImageIcon GITHUB_ICON;
    private static final ImageIcon DISCORD_ICON;
    private static final ImageIcon PATREON_ICON;
    private static final ImageIcon WIKI_ICON;
    private static final ImageIcon IMPORT_ICON;
    private static final Logger log;
    private final JLabel loggedLabel = new JLabel();
    private final JRichTextPane emailLabel = new JRichTextPane();
    private JPanel syncPanel;
    private JPanel actionsContainer;
    @Inject
    @Nullable
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private EventBus eventBus;
    @Inject
    private SessionManager sessionManager;
    @Inject
    private ScheduledExecutorService executor;
    @Inject
    private ConfigManager configManager;
    @Inject
    @Named(value="runelite.version")
    private String runeliteVersion;
    @Inject
    @Named(value="runelite.github.link")
    private String githubLink;
    @Inject
    @Named(value="runelite.discord.invite")
    private String discordInvite;
    @Inject
    @Named(value="runelite.patreon.link")
    private String patreonLink;
    @Inject
    @Named(value="runelite.wiki.link")
    private String wikiLink;
    private volatile boolean updatePing = false;
    private volatile Socket pingSocket;
    private volatile int pingWorldId = 1;

    private static String getColor(long value) {
        if (value <= 0L) {
            return "#00FF00";
        }
        if (value >= 255L) {
            return "#FF0000";
        }
        int red = (int)value;
        int green = (int)(255L - value);
        int blue = 0;
        return String.format("#%02X%02X%02X", red, green, blue);
    }

    private static String pingStatus(long ms) {
        String color = InfoPanel.getColor(ms);
        return "<span style = 'color:" + color + "'>" + ms + "ms</span>";
    }

    @Nullable
    private String getPingStatus() throws Exception {
        World[] worldList;
        Client client;
        block14: {
            block13: {
                client = this.client;
                if (client == null) {
                    return null;
                }
                if (!GameState.LOGGED_IN.equals((Object)client.getGameState())) {
                    return null;
                }
                worldList = client.getWorldList();
                if (worldList == null) break block13;
                if (worldList.length != 0) break block14;
            }
            this.clientThread.invokeLater(client::loadWorlds);
            return null;
        }
        int worldId = client.getWorld();
        if (worldId < 1 || worldId > worldList.length) {
            return null;
        }
        World world = worldList[worldId - 1];
        if (world == null) {
            return null;
        }
        Socket socket = this.pingSocket;
        if (this.pingWorldId != worldId || socket == null || !socket.isConnected() || socket.isClosed()) {
            log.info("Creating new ping socket for world {}", (Object)worldId);
            if (socket != null && !socket.isClosed()) {
                try {
                    log.info("Closing old ping socket for world {}", (Object)this.pingWorldId);
                    socket.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            String hostName = world.getAddress();
            int hostPort = RSPSConstants.DEFAULT_PORT;
            socket = new Socket();
            socket.setKeepAlive(true);
            socket.setSoTimeout(15000);
            socket.setTcpNoDelay(true);
            socket.setReceiveBufferSize(65536);
            socket.setSendBufferSize(65536);
            socket.connect(new InetSocketAddress(hostName, hostPort));
            OutputStream out = socket.getOutputStream();
            out.write(200);
            out.flush();
            this.pingSocket = socket;
            this.pingWorldId = worldId;
        }
        OutputStream out = socket.getOutputStream();
        InputStream in = socket.getInputStream();
        int value = 1;
        long start = System.nanoTime();
        out.write(value);
        out.flush();
        if (value == in.read()) {
            long end = System.nanoTime();
            long elapsed = end - start;
            long elapsedMs = TimeUnit.NANOSECONDS.toMillis(elapsed);
            return InfoPanel.pingStatus(elapsedMs);
        }
        socket.close();
        return null;
    }

    private void updatePing(JLabel ping) {
        String status = "<span style = 'color:red'>DISCONNECTED</span>";
        try {
            Socket pingSocket;
            String pingStatus = this.getPingStatus();
            if (pingStatus == null && (pingSocket = this.pingSocket) != null) {
                this.pingSocket = null;
                try {
                    pingSocket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (pingStatus != null) {
                status = pingStatus;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        ping.setText(InfoPanel.htmlLabel("Ping: ", status));
    }

    void init() {
        this.setLayout(new BorderLayout());
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        JPanel versionPanel = new JPanel();
        versionPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        versionPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        versionPanel.setLayout(new GridLayout(0, 1));
        Font smallFont = FontManager.getRunescapeSmallFont();
        JLabel rlVersion = new JLabel(InfoPanel.htmlLabel("RuneLite version: ", this.runeliteVersion));
        rlVersion.setFont(smallFont);
        JLabel oprsVersion = new JLabel(InfoPanel.htmlLabel("OpenOSRS version: ", OpenOSRS.SYSTEM_VERSION));
        oprsVersion.setFont(smallFont);
        JLabel revision = new JLabel();
        revision.setFont(smallFont);
        String engineVer = "Unknown";
        if (this.client != null) {
            engineVer = String.format("Rev %d", this.client.getRevision());
        }
        revision.setText(InfoPanel.htmlLabel("OldSchool revision: ", engineVer));
        JLabel launcher = new JLabel(InfoPanel.htmlLabel("Launcher version: ", MoreObjects.firstNonNull(RuneLiteProperties.getLauncherVersion(), "Unknown")));
        launcher.setFont(smallFont);
        JLabel ping = new JLabel();
        ping.setFont(smallFont);
        this.updatePing(ping);
        this.updatePing = true;
        Thread pingThread = new Thread(() -> {
            while (this.updatePing && !Thread.interrupted()) {
                long start = System.nanoTime();
                this.updatePing(ping);
                long end = System.nanoTime();
                long elapsed = end - start;
                long elapsedMs = TimeUnit.NANOSECONDS.toMillis(elapsed);
                long sleepMs = 3000L - elapsedMs;
                if (sleepMs <= 0L) continue;
                try {
                    Thread.sleep(sleepMs);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    return;
                }
            }
        }, "Info Panel Ping Thread");
        pingThread.setDaemon(true);
        pingThread.setPriority(4);
        pingThread.start();
        this.loggedLabel.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
        this.loggedLabel.setFont(smallFont);
        this.emailLabel.setForeground(Color.WHITE);
        this.emailLabel.setFont(smallFont);
        this.emailLabel.enableAutoLinkHandler(false);
        this.emailLabel.addHyperlinkListener(e -> {
            if (HyperlinkEvent.EventType.ACTIVATED.equals(e.getEventType()) && e.getURL() != null && e.getURL().toString().equals(RUNELITE_LOGIN)) {
                this.executor.execute(this.sessionManager::login);
            }
        });
        versionPanel.add(rlVersion);
        versionPanel.add(oprsVersion);
        versionPanel.add(revision);
        versionPanel.add(launcher);
        versionPanel.add(ping);
        versionPanel.add(Box.createGlue());
        versionPanel.add(this.loggedLabel);
        versionPanel.add(this.emailLabel);
        this.actionsContainer = new JPanel();
        this.actionsContainer.setBorder(new EmptyBorder(10, 0, 0, 0));
        this.actionsContainer.setLayout(new GridLayout(0, 1, 0, 10));
        this.syncPanel = InfoPanel.buildLinkPanel(IMPORT_ICON, "Import signed-out", "settings", () -> {
            int result = JOptionPane.showOptionDialog(this.syncPanel, "<html>This will overwrite your settings with settings from your local profile, which<br/>is the profile used when not signed into RuneLite with a RuneLite account.</html>", "Are you sure?", 0, 2, null, new String[]{"Yes", "No"}, "No");
            if (result == 0) {
                this.configManager.importLocal();
            }
        });
        this.actionsContainer.add(InfoPanel.buildLinkPanel(GITHUB_ICON, "Report an issue or", "make a suggestion", this.githubLink));
        this.actionsContainer.add(InfoPanel.buildLinkPanel(DISCORD_ICON, "Talk to us on our", "Discord server", this.discordInvite));
        this.actionsContainer.add(InfoPanel.buildLinkPanel(PATREON_ICON, "Become a patron to", "help support OpenOSRS", this.patreonLink));
        this.actionsContainer.add(InfoPanel.buildLinkPanel(WIKI_ICON, "Information about", "RuneLite and plugins", this.wikiLink));
        this.add((Component)versionPanel, "North");
        this.add((Component)this.actionsContainer, "Center");
        this.updateLoggedIn();
        this.eventBus.register(this);
    }

    void deinit() {
        this.eventBus.unregister(this);
    }

    private static JPanel buildLinkPanel(ImageIcon icon, String topText, String bottomText, String url) {
        return InfoPanel.buildLinkPanel(icon, topText, bottomText, () -> LinkBrowser.browse(url));
    }

    private static JPanel buildLinkPanel(ImageIcon icon, String topText, String bottomText, final Runnable callback) {
        final JPanel container = new JPanel();
        container.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        container.setLayout(new BorderLayout());
        container.setBorder(new EmptyBorder(10, 10, 10, 10));
        final Color hoverColor = ColorScheme.DARKER_GRAY_HOVER_COLOR;
        final Color pressedColor = ColorScheme.DARKER_GRAY_COLOR.brighter();
        JLabel iconLabel = new JLabel(icon);
        container.add((Component)iconLabel, "West");
        final JPanel textContainer = new JPanel();
        textContainer.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        textContainer.setLayout(new GridLayout(2, 1));
        textContainer.setBorder(new EmptyBorder(5, 10, 5, 10));
        container.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                container.setBackground(pressedColor);
                textContainer.setBackground(pressedColor);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                callback.run();
                container.setBackground(hoverColor);
                textContainer.setBackground(hoverColor);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                container.setBackground(hoverColor);
                textContainer.setBackground(hoverColor);
                container.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                container.setBackground(ColorScheme.DARKER_GRAY_COLOR);
                textContainer.setBackground(ColorScheme.DARKER_GRAY_COLOR);
                container.setCursor(new Cursor(0));
            }
        });
        JLabel topLine = new JLabel(topText);
        topLine.setForeground(Color.WHITE);
        topLine.setFont(FontManager.getRunescapeSmallFont());
        JLabel bottomLine = new JLabel(bottomText);
        bottomLine.setForeground(Color.WHITE);
        bottomLine.setFont(FontManager.getRunescapeSmallFont());
        textContainer.add(topLine);
        textContainer.add(bottomLine);
        container.add((Component)textContainer, "Center");
        JLabel arrowLabel = new JLabel(ARROW_RIGHT_ICON);
        container.add((Component)arrowLabel, "East");
        return container;
    }

    private void updateLoggedIn() {
        String name;
        String string = name = this.sessionManager.getAccountSession() != null ? this.sessionManager.getAccountSession().getUsername() : null;
        if (name != null) {
            this.emailLabel.setContentType("text/plain");
            this.emailLabel.setText(name);
            this.loggedLabel.setText("Signed in as");
            this.actionsContainer.add((Component)this.syncPanel, 0);
        } else {
            this.emailLabel.setContentType("text/html");
            this.emailLabel.setText("<a href=\"https://runelite_login/\">Sign in</a> to sync settings to the cloud.");
            this.loggedLabel.setText("Not signed in");
            this.actionsContainer.remove(this.syncPanel);
        }
    }

    private static String htmlLabel(String key, String value) {
        return "<html><body style = 'color:#a5a5a5'>" + key + "<span style = 'color:white'>" + value + "</span></body></html>";
    }

    @Subscribe
    public void onSessionOpen(SessionOpen sessionOpen) {
        this.updateLoggedIn();
    }

    @Subscribe
    public void onSessionClose(SessionClose e) {
        this.updateLoggedIn();
    }

    static {
        log = LoggerFactory.getLogger(InfoPanel.class);
        ARROW_RIGHT_ICON = new ImageIcon(ImageUtil.loadImageResource(InfoPanel.class, "/util/arrow_right.png"));
        GITHUB_ICON = new ImageIcon(ImageUtil.loadImageResource(InfoPanel.class, "github_icon.png"));
        DISCORD_ICON = new ImageIcon(ImageUtil.loadImageResource(InfoPanel.class, "discord_icon.png"));
        PATREON_ICON = new ImageIcon(ImageUtil.loadImageResource(InfoPanel.class, "patreon_icon.png"));
        WIKI_ICON = new ImageIcon(ImageUtil.loadImageResource(InfoPanel.class, "wiki_icon.png"));
        IMPORT_ICON = new ImageIcon(ImageUtil.loadImageResource(InfoPanel.class, "import_icon.png"));
    }
}

