/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.attackstyles;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.inject.Provides;
import java.util.EnumSet;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Skill;
import net.runelite.api.VarPlayer;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.api.events.VarbitChanged;
import net.runelite.api.widgets.Widget;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.attackstyles.AttackStyle;
import net.runelite.client.plugins.attackstyles.AttackStylesConfig;
import net.runelite.client.plugins.attackstyles.AttackStylesOverlay;
import net.runelite.client.plugins.attackstyles.WeaponType;
import net.runelite.client.ui.overlay.OverlayManager;

@PluginDescriptor(name="Attack Styles", description="Show your current attack style as an overlay", tags={"combat", "defence", "magic", "overlay", "ranged", "strength", "warn", "pure"})
public class AttackStylesPlugin
extends Plugin {
    private int equippedWeaponTypeVarbit = -1;
    private AttackStyle attackStyle;
    private AttackStyle prevAttackStyle;
    private final Set<Skill> warnedSkills = EnumSet.noneOf(Skill.class);
    private boolean warnedSkillSelected;
    private final Table<WeaponType, Integer, Boolean> widgetsToHide = HashBasedTable.create();
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private AttackStylesConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private AttackStylesOverlay overlay;
    @Inject
    private ChatMessageManager chatManager;

    @Provides
    AttackStylesConfig provideConfig(ConfigManager configManager) {
        return configManager.getConfig(AttackStylesConfig.class);
    }

    @Override
    protected void startUp() throws Exception {
        this.overlayManager.add(this.overlay);
        this.clientThread.invoke(() -> {
            this.resetWarnings();
            if (this.client.getGameState() == GameState.LOGGED_IN) {
                int attackStyleVarbit = this.client.getVarpValue(VarPlayer.ATTACK_STYLE);
                this.equippedWeaponTypeVarbit = this.client.getVarbitValue(357);
                int castingModeVarbit = this.client.getVarbitValue(2668);
                this.updateAttackStyle(this.equippedWeaponTypeVarbit, attackStyleVarbit, castingModeVarbit);
                this.updateWarning();
                this.processWidgets();
            }
        });
    }

    @Override
    protected void shutDown() {
        this.overlayManager.remove(this.overlay);
        this.updateWidgetsToHide(false);
        this.processWidgets();
        AttackStylesPlugin.hideWidget(this.client.getWidget(38862878), false);
        this.warnedSkills.clear();
    }

    @Nullable
    AttackStyle getAttackStyle() {
        return this.attackStyle;
    }

    boolean isWarnedSkillSelected() {
        return this.warnedSkillSelected;
    }

    @Subscribe
    public void onScriptPostFired(ScriptPostFired scriptPostFired) {
        if (scriptPostFired.getScriptId() == 420) {
            this.processWidgets();
        }
    }

    private void processWidgets() {
        WeaponType equippedWeaponType = WeaponType.getWeaponType(this.equippedWeaponTypeVarbit);
        if (this.widgetsToHide.containsRow((Object)equippedWeaponType)) {
            for (int componentId : this.widgetsToHide.row(equippedWeaponType).keySet()) {
                AttackStylesPlugin.hideWidget(this.client.getWidget(componentId), this.widgetsToHide.get((Object)equippedWeaponType, componentId));
            }
        }
        AttackStylesPlugin.hideWidget(this.client.getWidget(38862878), this.config.hideAutoRetaliate());
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        if (event.getVarpId() == VarPlayer.ATTACK_STYLE.getId() || event.getVarbitId() == 357 || event.getVarbitId() == 2668) {
            int currentAttackStyleVarbit = this.client.getVarpValue(VarPlayer.ATTACK_STYLE);
            int currentEquippedWeaponTypeVarbit = this.client.getVarbitValue(357);
            int currentCastingModeVarbit = this.client.getVarbitValue(2668);
            boolean weaponSwitch = currentEquippedWeaponTypeVarbit != this.equippedWeaponTypeVarbit;
            this.equippedWeaponTypeVarbit = currentEquippedWeaponTypeVarbit;
            this.updateAttackStyle(this.equippedWeaponTypeVarbit, currentAttackStyleVarbit, currentCastingModeVarbit);
            this.updateWarning();
            if (weaponSwitch) {
                this.processWidgets();
            }
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("attackIndicator")) {
            boolean enabled = Boolean.TRUE.toString().equals(event.getNewValue());
            switch (event.getKey()) {
                case "warnForDefensive": {
                    this.updateWarnedSkills(enabled, Skill.DEFENCE);
                    break;
                }
                case "warnForAttack": {
                    this.updateWarnedSkills(enabled, Skill.ATTACK);
                    break;
                }
                case "warnForStrength": {
                    this.updateWarnedSkills(enabled, Skill.STRENGTH);
                    break;
                }
                case "warnForRanged": {
                    this.updateWarnedSkills(enabled, Skill.RANGED);
                    break;
                }
                case "warnForMagic": {
                    this.updateWarnedSkills(enabled, Skill.MAGIC);
                    break;
                }
                case "removeWarnedStyles": {
                    this.updateWidgetsToHide(enabled);
                }
            }
            this.clientThread.invokeLater(this::processWidgets);
        }
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        if (this.attackStyle != this.prevAttackStyle && this.warnedSkillSelected && this.config.showChatWarnings()) {
            String message = new ChatMessageBuilder().append(ChatColorType.HIGHLIGHT).append("Your attack style has been changed to " + this.attackStyle.getName()).build();
            this.chatManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(message).build());
        }
        this.prevAttackStyle = this.attackStyle;
    }

    private void resetWarnings() {
        this.updateWarnedSkills(this.config.warnForAttack(), Skill.ATTACK);
        this.updateWarnedSkills(this.config.warnForStrength(), Skill.STRENGTH);
        this.updateWarnedSkills(this.config.warnForDefence(), Skill.DEFENCE);
        this.updateWarnedSkills(this.config.warnForRanged(), Skill.RANGED);
        this.updateWarnedSkills(this.config.warnForMagic(), Skill.MAGIC);
    }

    private void updateAttackStyle(int equippedWeaponType, int attackStyleIndex, int castingMode) {
        AttackStyle[] attackStyles = WeaponType.getWeaponType(equippedWeaponType).getAttackStyles();
        if (attackStyleIndex < attackStyles.length) {
            this.attackStyle = attackStyles[attackStyleIndex];
            if (this.attackStyle == null) {
                this.attackStyle = AttackStyle.OTHER;
            } else if (this.attackStyle == AttackStyle.CASTING && castingMode == 1) {
                this.attackStyle = AttackStyle.DEFENSIVE_CASTING;
            }
        }
    }

    private void updateWarnedSkills(boolean enabled, Skill skill) {
        if (enabled) {
            this.warnedSkills.add(skill);
        } else {
            this.warnedSkills.remove((Object)skill);
        }
        this.updateWarning();
    }

    private void updateWarning() {
        this.warnedSkillSelected = false;
        if (this.attackStyle != null) {
            for (Skill skill : this.attackStyle.getSkills()) {
                if (!this.warnedSkills.contains((Object)skill)) continue;
                this.warnedSkillSelected = true;
                break;
            }
        }
        this.updateWidgetsToHide(this.config.removeWarnedStyles());
    }

    private void updateWidgetsToHide(boolean enabled) {
        WeaponType equippedWeaponType = WeaponType.getWeaponType(this.equippedWeaponTypeVarbit);
        if (equippedWeaponType == null) {
            return;
        }
        AttackStyle[] attackStyles = equippedWeaponType.getAttackStyles();
        block7: for (int i = 0; i < attackStyles.length; ++i) {
            AttackStyle attackStyle = attackStyles[i];
            if (attackStyle == null) continue;
            boolean warnedSkill = false;
            for (Skill skill : attackStyle.getSkills()) {
                if (!this.warnedSkills.contains((Object)skill)) continue;
                warnedSkill = true;
                break;
            }
            if (attackStyle == AttackStyle.DEFENSIVE_CASTING || !enabled) {
                this.widgetsToHide.put(equippedWeaponType, 38862869, enabled && warnedSkill);
                this.widgetsToHide.put(equippedWeaponType, 38862871, enabled && warnedSkill);
                this.widgetsToHide.put(equippedWeaponType, 38862872, enabled && warnedSkill);
                this.widgetsToHide.put(equippedWeaponType, 38862873, enabled && warnedSkill);
            }
            switch (i) {
                case 0: {
                    this.widgetsToHide.put(equippedWeaponType, 38862852, enabled && warnedSkill);
                    continue block7;
                }
                case 1: {
                    this.widgetsToHide.put(equippedWeaponType, 38862856, enabled && warnedSkill);
                    continue block7;
                }
                case 2: {
                    this.widgetsToHide.put(equippedWeaponType, 38862860, enabled && warnedSkill);
                    continue block7;
                }
                case 3: {
                    this.widgetsToHide.put(equippedWeaponType, 38862864, enabled && warnedSkill);
                    continue block7;
                }
                case 4: {
                    this.widgetsToHide.put(equippedWeaponType, 38862868, enabled && warnedSkill);
                    continue block7;
                }
            }
        }
    }

    private static void hideWidget(Widget widget, boolean hidden) {
        if (widget != null) {
            widget.setHidden(hidden);
        }
    }

    @VisibleForTesting
    Set<Skill> getWarnedSkills() {
        return this.warnedSkills;
    }

    @VisibleForTesting
    Table<WeaponType, Integer, Boolean> getHiddenWidgets() {
        return this.widgetsToHide;
    }
}

