/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.hiscore;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import javax.inject.Inject;
import net.runelite.client.hiscore.HiscoreEndpoint;
import net.runelite.client.hiscore.HiscoreResult;
import net.runelite.client.hiscore.HiscoreResultBuilder;
import net.runelite.client.hiscore.Skill;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiscoreClient {
    private static final Logger log = LoggerFactory.getLogger(HiscoreClient.class);
    private final OkHttpClient client;

    @Inject
    public HiscoreClient(OkHttpClient client) {
        this.client = client;
    }

    public HiscoreResult lookup(String username, HiscoreEndpoint endpoint) throws IOException {
        return this.lookup(username, endpoint.getHiscoreURL());
    }

    public CompletableFuture<HiscoreResult> lookupAsync(String username, HiscoreEndpoint endpoint) {
        return this.lookupAsync(username, endpoint.getHiscoreURL());
    }

    public HiscoreResult lookup(String username, HttpUrl endpoint) throws IOException {
        return this.lookupSync(username, endpoint);
    }

    public HiscoreResult lookup(String username) throws IOException {
        return this.lookup(username, HiscoreEndpoint.NORMAL);
    }

    private HiscoreResult lookupSync(String username, HttpUrl hiscoreUrl) throws IOException {
        try (Response response = this.client.newCall(HiscoreClient.buildRequest(username, hiscoreUrl)).execute();){
            HiscoreResult hiscoreResult = HiscoreClient.processResponse(username, response);
            return hiscoreResult;
        }
    }

    private CompletableFuture<HiscoreResult> lookupAsync(final String username, HttpUrl hiscoreUrl) {
        final CompletableFuture<HiscoreResult> future = new CompletableFuture<HiscoreResult>();
        this.client.newCall(HiscoreClient.buildRequest(username, hiscoreUrl)).enqueue(new Callback(){

            @Override
            public void onFailure(Call call, IOException e) {
                future.completeExceptionally(e);
            }

            @Override
            public void onResponse(Call call, Response response) throws IOException {
                try {
                    future.complete(HiscoreClient.processResponse(username, response));
                }
                finally {
                    response.close();
                }
            }
        });
        return future;
    }

    private static Request buildRequest(String username, HttpUrl hiscoreUrl) {
        HttpUrl url = hiscoreUrl.newBuilder().addQueryParameter("player", username).build();
        log.debug("Built URL {}", (Object)url);
        return new Request.Builder().url(url).build();
    }

    private static HiscoreResult processResponse(String username, Response response) throws IOException {
        if (!response.isSuccessful()) {
            if (response.code() == 404) {
                return null;
            }
            throw new IOException("Error retrieving data from Jagex Hiscores: " + String.valueOf(response));
        }
        String responseStr = response.body().string();
        return HiscoreClient.parseResponse(username, responseStr);
    }

    private static HiscoreResult parseResponse(String username, String responseStr) throws IOException {
        if (responseStr.equalsIgnoreCase("404")) {
            return null;
        }
        JsonParser jsonParser = new JsonParser();
        jsonParser.parse(responseStr);
        JsonElement jsonParsed = jsonParser.parse(responseStr);
        JsonArray highscores = jsonParsed.getAsJsonObject().getAsJsonArray("skills");
        System.out.println(highscores);
        HiscoreResultBuilder hiscoreBuilder = new HiscoreResultBuilder(username);
        boolean count = false;
        if (highscores.size() < 23) {
            return null;
        }
        for (int i = 0; i < highscores.size(); ++i) {
            JsonObject individualLine = highscores.get(i).getAsJsonObject();
            Skill skill = new Skill(0, individualLine.get("level").getAsInt(), individualLine.get("xp").getAsLong());
            System.out.println(skill);
            hiscoreBuilder.setNextSkill(skill);
        }
        return hiscoreBuilder.build();
    }
}

