/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.externalplugins;

import com.google.gson.Gson;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.inject.Inject;
import javax.inject.Named;
import net.runelite.client.RuneLiteProperties;
import net.runelite.client.externalplugins.PluginHubManifest;
import net.runelite.client.util.VerificationException;
import net.runelite.http.api.RuneLiteAPI;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.BufferedSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalPluginClient {
    private static final Logger log = LoggerFactory.getLogger(ExternalPluginClient.class);
    private final OkHttpClient okHttpClient;
    private final Gson gson;
    private final HttpUrl apiBase;
    private final HttpUrl pluginHubBase;

    @Inject
    private ExternalPluginClient(OkHttpClient okHttpClient, Gson gson, @Named(value="runelite.api.base") HttpUrl apiBase, @Named(value="runelite.pluginhub.url") HttpUrl pluginHubBase) {
        this.okHttpClient = okHttpClient;
        this.gson = gson;
        this.apiBase = apiBase;
        this.pluginHubBase = pluginHubBase;
    }

    public PluginHubManifest.ManifestLite downloadManifestLite() throws IOException, VerificationException {
        return this.downloadManifest("lite", PluginHubManifest.ManifestLite.class);
    }

    public PluginHubManifest.ManifestFull downloadManifestFull() throws IOException, VerificationException {
        return this.downloadManifest("full", PluginHubManifest.ManifestFull.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T downloadManifest(String name, Class<T> clazz) throws IOException, VerificationException {
        HttpUrl manifest = this.pluginHubBase.newBuilder().addPathSegment("manifest").addPathSegment(RuneLiteProperties.getPluginHubVersion() + "_" + name + ".js").build();
        try (Response res = this.okHttpClient.newCall(new Request.Builder().url(manifest).build()).execute();){
            if (res.code() != 200) {
                throw new IOException("Non-OK response code: " + res.code());
            }
            BufferedSource src = res.body().source();
            byte[] signature = new byte[src.readInt()];
            src.readFully(signature);
            byte[] data = src.readByteArray();
            Signature s2 = Signature.getInstance("SHA256withRSA");
            s2.initVerify(ExternalPluginClient.loadCertificate());
            s2.update(data);
            if (!s2.verify(signature)) {
                throw new VerificationException("Unable to verify external plugin manifest");
            }
            T t = this.gson.fromJson(new String(data, StandardCharsets.UTF_8), clazz);
            return t;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new VerificationException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage downloadIcon(PluginHubManifest.DisplayData plugin) throws IOException {
        if (plugin.getIconHash() == null) {
            return null;
        }
        HttpUrl url = this.pluginHubBase.newBuilder().addPathSegment("icon").addPathSegment(plugin.getInternalName() + "_" + plugin.getIconHash() + ".png").build();
        try (Response res = this.okHttpClient.newCall(new Request.Builder().url(url).build()).execute();){
            byte[] bytes = res.body().bytes();
            Class<ImageIO> clazz = ImageIO.class;
            synchronized (ImageIO.class) {
                BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(bytes));
                // ** MonitorExit[var5_6] (shouldn't be in output)
                return bufferedImage;
            }
        }
    }

    HttpUrl getJarURL(PluginHubManifest.JarData plugin) {
        return this.pluginHubBase.newBuilder().addPathSegment("jar").addPathSegment(plugin.getInternalName() + "_" + plugin.getJarHash() + ".jar").build();
    }

    private static Certificate loadCertificate() {
        Certificate certificate;
        block8: {
            InputStream in = ExternalPluginClient.class.getResourceAsStream("externalplugins.crt");
            try {
                CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
                certificate = certFactory.generateCertificate(in);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | CertificateException e) {
                    throw new RuntimeException(e);
                }
            }
            in.close();
        }
        return certificate;
    }

    void submitPlugins(List<String> plugins) {
        if (plugins.isEmpty()) {
            return;
        }
        HttpUrl url = this.apiBase.newBuilder().addPathSegment("pluginhub").build();
        Request request = new Request.Builder().url(url).post(RequestBody.create(RuneLiteAPI.JSON, this.gson.toJson(plugins))).build();
        this.okHttpClient.newCall(request).enqueue(new Callback(){

            @Override
            public void onFailure(Call call, IOException e) {
                log.debug("Error submitting plugins", e);
            }

            @Override
            public void onResponse(Call call, Response response) {
                log.debug("Submitted plugin list");
                response.close();
            }
        });
    }

    public Map<String, Integer> getPluginCounts() throws IOException {
        return new HashMap<String, Integer>();
    }
}

