/*
 * Decompiled with CFR 0.152.
 */
package mapped;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import mapped.AbstractArchive;
import mapped.AbstractWorldMapIcon;
import mapped.Actor;
import mapped.Buffer;
import mapped.Client;
import mapped.ClientPacket;
import mapped.Coord;
import mapped.Font;
import mapped.FontName;
import mapped.IndexedSprite;
import mapped.MidiPcmStream;
import mapped.NpcOverrides;
import mapped.PacketBufferNode;
import mapped.Rasterizer2D;
import mapped.ScriptEvent;
import mapped.SequenceDefinition;
import mapped.SpotAnimationDefinition;
import mapped.SpritePixels;
import mapped.WorldMapArchiveLoader;
import mapped.WorldMapArea;
import mapped.WorldMapCacheName;
import mapped.WorldMapElement;
import mapped.WorldMapEvent;
import mapped.WorldMapLabelSize;
import mapped.WorldMapRegion;
import mapped.WorldMapRenderer;
import mapped.WorldMapSectionType;
import mapped.class101;
import mapped.class113;
import mapped.class137;
import mapped.class141;
import mapped.class157;
import mapped.class223;
import net.runelite.api.Point;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.worldmap.WorldMapData;
import net.runelite.mapping.ObfuscatedGetter;
import net.runelite.mapping.ObfuscatedName;
import net.runelite.mapping.ObfuscatedSignature;
import net.runelite.rs.api.RSWorldMap;
import net.runelite.rs.api.RSWorldMapArea;
import net.runelite.rs.api.RSWorldMapRenderer;

@ObfuscatedName(value="tn")
public class WorldMap
implements RSWorldMap {
    @ObfuscatedName(value="az")
    @ObfuscatedSignature(descriptor="Lth;")
    static final FontName fontNameVerdana11 = FontName.FontName_verdana11;
    @ObfuscatedName(value="ap")
    @ObfuscatedSignature(descriptor="Lth;")
    static final FontName fontNameVerdana13 = FontName.FontName_verdana13;
    @ObfuscatedName(value="av")
    @ObfuscatedSignature(descriptor="Lth;")
    static final FontName fontNameVerdana15 = FontName.FontName_verdana15;
    @ObfuscatedName(value="aa")
    @ObfuscatedSignature(descriptor="Lol;")
    AbstractArchive WorldMap_archive;
    @ObfuscatedName(value="ac")
    @ObfuscatedSignature(descriptor="Lol;")
    AbstractArchive WorldMap_geographyArchive;
    @ObfuscatedName(value="al")
    @ObfuscatedSignature(descriptor="Lol;")
    AbstractArchive WorldMap_groundArchive;
    @ObfuscatedName(value="ax")
    @ObfuscatedSignature(descriptor="Lpf;")
    Font font;
    @ObfuscatedName(value="as")
    HashMap fonts;
    @ObfuscatedName(value="ay")
    @ObfuscatedSignature(descriptor="[Lup;")
    IndexedSprite[] mapSceneSprites;
    @ObfuscatedName(value="ak")
    HashMap details;
    @ObfuscatedName(value="aj")
    @ObfuscatedSignature(descriptor="Ljv;")
    WorldMapArea mainMapArea;
    @ObfuscatedName(value="am")
    @ObfuscatedSignature(descriptor="Ljv;")
    WorldMapArea currentMapArea;
    @ObfuscatedName(value="aq")
    @ObfuscatedSignature(descriptor="Ljv;")
    WorldMapArea field4981;
    @ObfuscatedName(value="ai")
    @ObfuscatedSignature(descriptor="Ljf;")
    WorldMapRenderer worldMapRenderer;
    @ObfuscatedName(value="aw")
    @ObfuscatedSignature(descriptor="Lsl;")
    WorldMapArchiveLoader cacheLoader;
    @ObfuscatedName(value="ae")
    @ObfuscatedGetter(intValue=989599695)
    int centerTileX;
    @ObfuscatedName(value="an")
    @ObfuscatedGetter(intValue=-1842715425)
    int centerTileY;
    @ObfuscatedName(value="ag")
    @ObfuscatedGetter(intValue=1462214999)
    int worldMapTargetX = -1;
    @ObfuscatedName(value="ad")
    @ObfuscatedGetter(intValue=-1451739569)
    int worldMapTargetY = -1;
    @ObfuscatedName(value="af")
    float zoom;
    @ObfuscatedName(value="be")
    float zoomTarget;
    @ObfuscatedName(value="bd")
    @ObfuscatedGetter(intValue=-1409287467)
    int worldMapDisplayWidth = -1;
    @ObfuscatedName(value="bl")
    @ObfuscatedGetter(intValue=-814173773)
    int worldMapDisplayHeight = -1;
    @ObfuscatedName(value="bi")
    @ObfuscatedGetter(intValue=1673613801)
    int worldMapDisplayX = -1;
    @ObfuscatedName(value="bv")
    @ObfuscatedGetter(intValue=-1846910385)
    int worldMapDisplayY = -1;
    @ObfuscatedName(value="bf")
    @ObfuscatedGetter(intValue=228098407)
    int maxFlashCount = 3;
    @ObfuscatedName(value="bg")
    @ObfuscatedGetter(intValue=1322618821)
    int cyclesPerFlash = 50;
    @ObfuscatedName(value="ba")
    boolean perpetualFlash = false;
    @ObfuscatedName(value="bm")
    HashSet flashingElements = null;
    @ObfuscatedName(value="bp")
    @ObfuscatedGetter(intValue=229151135)
    int flashCount = -1;
    @ObfuscatedName(value="bw")
    @ObfuscatedGetter(intValue=2141545241)
    int flashCycle = -1;
    @ObfuscatedName(value="bj")
    @ObfuscatedGetter(intValue=1677377671)
    int field4944 = -1;
    @ObfuscatedName(value="bn")
    @ObfuscatedGetter(intValue=-806246395)
    int field4959 = -1;
    @ObfuscatedName(value="bo")
    @ObfuscatedGetter(intValue=-430517989)
    int field4979 = -1;
    @ObfuscatedName(value="bt")
    @ObfuscatedGetter(intValue=268881779)
    int field4962 = -1;
    @ObfuscatedName(value="bu")
    @ObfuscatedGetter(longValue=4050134236144253029L)
    long field4963;
    @ObfuscatedName(value="by")
    @ObfuscatedGetter(intValue=-876124577)
    int field4939;
    @ObfuscatedName(value="bh")
    @ObfuscatedGetter(intValue=-2072001517)
    int field4965;
    @ObfuscatedName(value="bz")
    boolean field4968 = true;
    @ObfuscatedName(value="bx")
    HashSet enabledElements = new HashSet();
    @ObfuscatedName(value="bb")
    HashSet enabledCategories = new HashSet();
    @ObfuscatedName(value="bk")
    HashSet enabledElementIds = new HashSet();
    @ObfuscatedName(value="br")
    HashSet field4943 = new HashSet();
    @ObfuscatedName(value="bq")
    boolean elementsDisabled = false;
    @ObfuscatedName(value="cf")
    @ObfuscatedGetter(intValue=469849587)
    int field4972 = 0;
    @ObfuscatedName(value="cv")
    final int[] menuOpcodes = new int[]{1008, 1009, 1010, 1011, 1012};
    @ObfuscatedName(value="cx")
    List field4974;
    @ObfuscatedName(value="cp")
    Iterator iconIterator;
    @ObfuscatedName(value="ce")
    HashSet field4976 = new HashSet();
    @ObfuscatedName(value="ci")
    @ObfuscatedSignature(descriptor="Lmh;")
    Coord mouseCoord = null;
    @ObfuscatedName(value="ct")
    public boolean showCoord = false;
    @ObfuscatedName(value="cw")
    @ObfuscatedSignature(descriptor="Luz;")
    SpritePixels sprite;
    @ObfuscatedName(value="cq")
    @ObfuscatedGetter(intValue=17964725)
    int cachedPixelsPerTile;
    @ObfuscatedName(value="cl")
    @ObfuscatedGetter(intValue=521051339)
    int minCachedTileX = -1;
    @ObfuscatedName(value="cs")
    @ObfuscatedGetter(intValue=-1143944953)
    int minCachedTileY = -1;
    @ObfuscatedName(value="co")
    @ObfuscatedGetter(intValue=-893341489)
    int field4983 = -1;

    @ObfuscatedName(value="at")
    @ObfuscatedSignature(descriptor="(Lol;Lol;Lol;Lpf;Ljava/util/HashMap;[Lup;I)V", garbageValue="-686529494")
    public void method8714(AbstractArchive var1, AbstractArchive var2, AbstractArchive var3, Font var4, HashMap var5, IndexedSprite[] var6) {
        this.mapSceneSprites = var6;
        this.WorldMap_archive = var1;
        this.WorldMap_geographyArchive = var2;
        this.WorldMap_groundArchive = var3;
        this.font = var4;
        this.fonts = new HashMap();
        this.fonts.put(WorldMapLabelSize.WorldMapLabelSize_small, var5.get(fontNameVerdana11));
        this.fonts.put(WorldMapLabelSize.WorldMapLabelSize_medium, var5.get(fontNameVerdana13));
        this.fonts.put(WorldMapLabelSize.WorldMapLabelSize_large, var5.get(fontNameVerdana15));
        this.cacheLoader = new WorldMapArchiveLoader(var1);
        int var7 = this.WorldMap_archive.getGroupId_base(WorldMapCacheName.field2633.name);
        int[] var8 = this.WorldMap_archive.getGroupFileIds_base(var7);
        int var9 = var8 == null ? 0 : var8.length;
        this.details = new HashMap(var9);
        for (int var10 = 0; var10 < var9; ++var10) {
            Buffer var11 = new Buffer(this.WorldMap_archive.takeFile_base(var7, var8[var10]));
            WorldMapArea var12 = new WorldMapArea();
            var12.method4547(var11, var8[var10], Client.revision >= 217);
            this.details.put(var12.getInternalName_base(), var12);
            if (!var12.getIsMain_base()) continue;
            this.mainMapArea = var12;
        }
        this.method8729(this.mainMapArea);
        this.field4981 = null;
    }

    @ObfuscatedName(value="ah")
    @ObfuscatedSignature(descriptor="(I)V", garbageValue="1839563363")
    public void method8713_base() {
        WorldMapRegion.WorldMapRegion_cachedSprites.demote_base(5);
    }

    @ObfuscatedName(value="ar")
    @ObfuscatedSignature(descriptor="(IIZIIIII)V", garbageValue="-1895076651")
    public void onCycle_base(int var1, int var2, boolean var3, int var4, int var5, int var6, int var7) {
        if (this.cacheLoader.isLoaded_base()) {
            this.smoothZoom_base();
            this.scrollToTarget_base();
            if (var3) {
                WorldMapEvent var15;
                ScriptEvent var14;
                int var8 = (int)Math.ceil((float)var6 / this.zoom);
                int var9 = (int)Math.ceil((float)var7 / this.zoom);
                List var10 = this.worldMapRenderer.method4764_base(this.centerTileX - var8 / 2 - 1, this.centerTileY - var9 / 2 - 1, var8 / 2 + this.centerTileX + 1, var9 / 2 + this.centerTileY + 1, var4, var5, var6, var7, var1, var2);
                HashSet<AbstractWorldMapIcon> var11 = new HashSet<AbstractWorldMapIcon>();
                for (AbstractWorldMapIcon var13 : var10) {
                    var11.add(var13);
                    var14 = new ScriptEvent();
                    var15 = new WorldMapEvent(var13.getElement_base(), var13.coord1, var13.coord2);
                    var14.setArgs_base(new Object[]{var15, var1, var2});
                    if (this.field4976.contains(var13)) {
                        var14.setType_base(17);
                    } else {
                        var14.setType_base(15);
                    }
                    class157.method3403(var14);
                }
                for (AbstractWorldMapIcon var13 : this.field4976) {
                    if (var11.contains(var13)) continue;
                    var14 = new ScriptEvent();
                    var15 = new WorldMapEvent(var13.getElement_base(), var13.coord1, var13.coord2);
                    var14.setArgs_base(new Object[]{var15, var1, var2});
                    var14.setType_base(16);
                    class157.method3403(var14);
                }
                this.field4976 = var11;
            }
        }
    }

    @ObfuscatedName(value="ao")
    @ObfuscatedSignature(descriptor="(IIZZS)V", garbageValue="4180")
    public void method8715_base(int var1, int var2, boolean var3, boolean var4) {
        long var5 = SpotAnimationDefinition.method3775_base();
        this.method8716_base(var1, var2, var4, var5);
        if (!this.hasTarget_base() && (var4 || var3) && !PacketBufferNode.method5925_base()) {
            if (var4) {
                this.field4979 = var1;
                this.field4962 = var2;
                this.field4944 = this.centerTileX;
                this.field4959 = this.centerTileY;
            }
            if (this.field4944 != -1) {
                int var7 = var1 - this.field4979;
                int var8 = var2 - this.field4962;
                this.method8721(this.field4944 - (int)((float)var7 / this.zoomTarget), (int)((float)var8 / this.zoomTarget) + this.field4959, false, (byte)3);
            }
        } else {
            this.method8834_base();
        }
        if (var4) {
            this.field4963 = var5;
            this.field4939 = var1;
            this.field4965 = var2;
        }
    }

    @ObfuscatedName(value="ab")
    void method8716_base(int var1, int var2, boolean var3, long var4) {
        if (this.currentMapArea != null) {
            int var6 = (int)((float)this.centerTileX + ((float)(var1 - this.worldMapDisplayX) - (float)this.getDisplayWith_base() * this.zoom / 2.0f) / this.zoom);
            int var7 = (int)((float)this.centerTileY - ((float)(var2 - this.worldMapDisplayY) - (float)this.getDisplayHeight_base() * this.zoom / 2.0f) / this.zoom);
            this.mouseCoord = this.currentMapArea.method4552(var6 + this.currentMapArea.getRegionLowX_base() * 64, var7 + this.currentMapArea.getRegionLowY_base() * 64);
            if (this.mouseCoord != null && var3) {
                boolean var10;
                class223 var8 = Client.field724;
                boolean bl = var10 = Client.staffModLevel >= 2;
                if (var10 && var8.method4316_base(82) && var8.method4316_base(81)) {
                    int var16 = this.mouseCoord.x;
                    int var12 = this.mouseCoord.y;
                    int var13 = this.mouseCoord.plane;
                    PacketBufferNode var14 = class113.method2919(ClientPacket.TELEPORT, Client.packetWriter.isaacCipher);
                    var14.packetBuffer.writeInt_base(0);
                    var14.packetBuffer.writeShortAdd_base(var16);
                    var14.packetBuffer.writeShortAdd_base(var12);
                    var14.packetBuffer.writeByte_base(var13);
                    Client.packetWriter.method2867(var14);
                } else {
                    boolean var11 = true;
                    if (this.field4968) {
                        int var12 = var1 - this.field4939;
                        int var13 = var2 - this.field4965;
                        if (var4 - this.field4963 > 500L || var12 < -25 || var12 > 25 || var13 < -25 || var13 > 25) {
                            var11 = false;
                        }
                    }
                    if (var11) {
                        PacketBufferNode var15 = class113.method2919(ClientPacket.CLICKWORLDMAP, Client.packetWriter.isaacCipher);
                        var15.packetBuffer.writeIntLE_base(this.mouseCoord.packed_base());
                        Client.packetWriter.method2867(var15);
                        this.field4963 = 0L;
                    }
                }
            }
        } else {
            this.mouseCoord = null;
        }
    }

    @ObfuscatedName(value="au")
    @ObfuscatedSignature(descriptor="(I)V", garbageValue="217198758")
    void smoothZoom_base() {
        if (MidiPcmStream.field3456 != null) {
            this.zoom = this.zoomTarget;
        } else {
            if (this.zoom < this.zoomTarget) {
                this.zoom = Math.min(this.zoomTarget, this.zoom / 30.0f + this.zoom);
            }
            if (this.zoom > this.zoomTarget) {
                this.zoom = Math.max(this.zoomTarget, this.zoom - this.zoom / 30.0f);
            }
        }
    }

    @ObfuscatedName(value="aa")
    @ObfuscatedSignature(descriptor="(B)V", garbageValue="84")
    void scrollToTarget_base() {
        if (this.hasTarget_base()) {
            int var1 = this.worldMapTargetX - this.centerTileX;
            int var2 = this.worldMapTargetY - this.centerTileY;
            if (var1 != 0) {
                var1 /= Math.min(8, Math.abs(var1));
            }
            if (var2 != 0) {
                var2 /= Math.min(8, Math.abs(var2));
            }
            this.method8721(var1 + this.centerTileX, var2 + this.centerTileY, true, (byte)3);
            if (this.worldMapTargetX == this.centerTileX && this.worldMapTargetY == this.centerTileY) {
                this.worldMapTargetX = -1;
                this.worldMapTargetY = -1;
            }
        }
    }

    @ObfuscatedName(value="ac")
    final void method8721(int var1, int var2, boolean var3, byte var4) {
        this.centerTileX = var1;
        this.centerTileY = var2;
        SpotAnimationDefinition.method3775_base();
        if (var3) {
            if (var4 != 3) {
                return;
            }
            this.method8834_base();
        }
    }

    @ObfuscatedName(value="al")
    @ObfuscatedSignature(descriptor="(I)V", garbageValue="-249344526")
    final void method8834_base() {
        this.field4962 = -1;
        this.field4979 = -1;
        this.field4959 = -1;
        this.field4944 = -1;
    }

    @ObfuscatedName(value="az")
    @ObfuscatedSignature(descriptor="(I)Z", garbageValue="-357792182")
    boolean hasTarget_base() {
        return this.worldMapTargetX != -1 && this.worldMapTargetY != -1;
    }

    @ObfuscatedName(value="ap")
    @ObfuscatedSignature(descriptor="(IIII)Ljv;", garbageValue="-1247860535")
    public WorldMapArea method8724(int var1, int var2, int var3) {
        WorldMapArea var5;
        Iterator var4 = this.details.values().iterator();
        do {
            if (var4.hasNext()) continue;
            return null;
        } while (!(var5 = (WorldMapArea)var4.next()).containsCoord_base(var1, var2, var3));
        return var5;
    }

    @ObfuscatedName(value="av")
    @ObfuscatedSignature(descriptor="(IIIZB)V", garbageValue="1")
    public void method8723_base(int var1, int var2, int var3, boolean var4) {
        WorldMapArea var5 = this.method8724(var1, var2, var3);
        if (var5 == null) {
            if (!var4) {
                return;
            }
            var5 = this.mainMapArea;
        }
        boolean var6 = false;
        if (var5 != this.field4981 || var4) {
            this.field4981 = var5;
            this.method8729(var5);
            var6 = true;
        }
        if (var6 || var4) {
            this.jump_base(var1, var2, var3);
        }
    }

    @ObfuscatedName(value="ax")
    @ObfuscatedSignature(descriptor="(IS)V", garbageValue="-16384")
    public void setCurrentMapAreaId_base(int var1) {
        WorldMapArea var2 = this.method8799(var1);
        if (var2 != null) {
            this.method8729(var2);
        }
    }

    @ObfuscatedName(value="as")
    @ObfuscatedSignature(descriptor="(I)I", garbageValue="-370898847")
    public int currentMapAreaId_base() {
        return this.currentMapArea == null ? -1 : this.currentMapArea.getId_base();
    }

    @ObfuscatedName(value="ay")
    @ObfuscatedSignature(descriptor="(S)Ljv;", garbageValue="2772")
    public WorldMapArea method8901() {
        return this.currentMapArea;
    }

    @ObfuscatedName(value="ak")
    @ObfuscatedSignature(descriptor="(Ljv;I)V", garbageValue="724172563")
    void method8729(WorldMapArea var1) {
        if (this.currentMapArea == null || var1 != this.currentMapArea) {
            this.method8730(var1);
            this.jump_base(-1, -1, -1);
        }
    }

    @ObfuscatedName(value="aj")
    @ObfuscatedSignature(descriptor="(Ljv;B)V", garbageValue="6")
    void method8730(WorldMapArea var1) {
        this.currentMapArea = var1;
        this.worldMapRenderer = new WorldMapRenderer(this.mapSceneSprites, this.fonts, this.WorldMap_geographyArchive, this.WorldMap_groundArchive);
        this.cacheLoader.reset_base(this.currentMapArea == null ? null : this.currentMapArea.getInternalName_base());
    }

    @ObfuscatedName(value="am")
    @ObfuscatedSignature(descriptor="(Ljv;Lmh;Lmh;ZB)V", garbageValue="62")
    public void method8796(WorldMapArea var1, Coord var2, Coord var3, boolean var4) {
        if (var1 != null) {
            if (this.currentMapArea == null || var1 != this.currentMapArea) {
                this.method8730(var1);
            }
            if (!var4 && this.currentMapArea.containsCoord_base(var2.plane, var2.x, var2.y)) {
                this.jump_base(var2.plane, var2.x, var2.y);
            } else {
                this.jump_base(var3.plane, var3.x, var3.y);
            }
        }
    }

    @ObfuscatedName(value="aq")
    @ObfuscatedSignature(descriptor="(IIIB)V", garbageValue="0")
    void jump_base(int var1, int var2, int var3) {
        if (this.currentMapArea != null) {
            int[] var4 = this.currentMapArea.position_base(var1, var2, var3);
            if (var4 == null) {
                var4 = this.currentMapArea.position_base(this.currentMapArea.getOriginPlane_base(), this.currentMapArea.getOriginX_base(), this.currentMapArea.getOriginY_base());
            }
            this.method8721(var4[0] - this.currentMapArea.getRegionLowX_base() * 64, var4[1] - this.currentMapArea.getRegionLowY_base() * 64, true, (byte)3);
            this.worldMapTargetX = -1;
            this.worldMapTargetY = -1;
            this.zoomTarget = this.zoom = this.getZoomFromPercentage_base(this.currentMapArea.getZoom_base());
            this.field4974 = null;
            this.iconIterator = null;
            this.worldMapRenderer.clearIcons_base();
        }
    }

    @ObfuscatedName(value="ai")
    @ObfuscatedSignature(descriptor="(IIIIIB)V", garbageValue="24")
    public void draw_base(int var1, int var2, int var3, int var4, int var5) {
        int[] var6 = new int[4];
        Rasterizer2D.Rasterizer2D_getClipArray_base(var6);
        Rasterizer2D.Rasterizer2D_setClip_base(var1, var2, var3 + var1, var2 + var4);
        int var7 = this.cacheLoader.getPercentLoaded_base();
        if (var7 < 100) {
            this.drawLoading_base(var1, var2, var3, var4, var7);
        } else {
            boolean var10;
            if (!this.worldMapRenderer.isLoaded_base()) {
                this.worldMapRenderer.method4733(this.WorldMap_archive, this.currentMapArea.getInternalName_base(), Client.isMembersWorld, Client.revision >= 217);
                if (!this.worldMapRenderer.isLoaded_base()) {
                    return;
                }
            }
            Rasterizer2D.Rasterizer2D_fillRectangle_base(var1, var2, var3, var4, this.worldMapRenderer.method4741_base());
            if (this.flashingElements != null) {
                ++this.flashCycle;
                if (this.flashCycle % this.cyclesPerFlash == 0) {
                    this.flashCycle = 0;
                    ++this.flashCount;
                }
                if (this.flashCount >= this.maxFlashCount && !this.perpetualFlash) {
                    this.flashingElements = null;
                }
            }
            int var8 = (int)Math.ceil((float)var3 / this.zoom);
            int var9 = (int)Math.ceil((float)var4 / this.zoom);
            this.worldMapRenderer.drawTiles_base(this.centerTileX - var8 / 2, this.centerTileY - var9 / 2, var8 / 2 + this.centerTileX, var9 / 2 + this.centerTileY, var1, var2, var3 + var1, var2 + var4);
            if (!this.elementsDisabled) {
                var10 = false;
                if (var5 - this.field4972 > 100) {
                    this.field4972 = var5;
                    var10 = true;
                }
                this.worldMapRenderer.drawElements_base(this.centerTileX - var8 / 2, this.centerTileY - var9 / 2, var8 / 2 + this.centerTileX, var9 / 2 + this.centerTileY, var1, var2, var3 + var1, var2 + var4, this.field4943, this.flashingElements, this.flashCycle, this.cyclesPerFlash, var10);
            }
            this.method8733_base(var1, var2, var3, var4, var8, var9);
            boolean bl = var10 = Client.staffModLevel >= 2;
            if (var10 && this.showCoord && this.mouseCoord != null) {
                this.font.draw_base("Coord: " + this.mouseCoord, Rasterizer2D.Rasterizer2D_xClipStart + 10, Rasterizer2D.Rasterizer2D_yClipStart + 20, 0xFFFF00, -1);
            }
            this.worldMapDisplayWidth = var8;
            this.worldMapDisplayHeight = var9;
            this.worldMapDisplayX = var1;
            this.worldMapDisplayY = var2;
            Rasterizer2D.Rasterizer2D_setClipArray_base(var6);
        }
    }

    @ObfuscatedName(value="aw")
    @ObfuscatedSignature(descriptor="(IIIIIII)Z", garbageValue="-2129366613")
    boolean method8750_base(int var1, int var2, int var3, int var4, int var5, int var6) {
        return this.sprite == null ? true : (this.sprite.subWidth == var1 && this.sprite.subHeight == var2 ? (this.worldMapRenderer.pixelsPerTile != this.cachedPixelsPerTile ? true : (this.field4983 != Client.field783 ? true : (var3 <= 0 && var4 <= 0 ? var3 + var1 < var5 || var2 + var4 < var6 : true))) : true);
    }

    @ObfuscatedName(value="ae")
    @ObfuscatedSignature(descriptor="(IIIIIII)V", garbageValue="1396727376")
    void method8733_base(int var1, int var2, int var3, int var4, int var5, int var6) {
        if (MidiPcmStream.field3456 != null) {
            int var12;
            int var14;
            int var7 = 512 / (this.worldMapRenderer.pixelsPerTile * 2);
            int var8 = var3 + 512;
            int var9 = var4 + 512;
            float var10 = 1.0f;
            int var11 = this.getDisplayX_base() - var5 / 2 - var7;
            int var13 = var1 - (var11 + var7 - this.minCachedTileX) * this.worldMapRenderer.pixelsPerTile;
            if (this.method8750_base(var8 = (int)((float)var8 / var10), var9 = (int)((float)var9 / var10), var13, var14 = var2 - this.worldMapRenderer.pixelsPerTile * (var7 - ((var12 = this.getDisplayY_base() - var6 / 2 - var7) - this.minCachedTileY)), var3, var4)) {
                if (this.sprite != null && this.sprite.subWidth == var8 && this.sprite.subHeight == var9) {
                    Arrays.fill(this.sprite.pixels, 0);
                } else {
                    this.sprite = new SpritePixels(var8, var9);
                }
                this.minCachedTileX = this.getDisplayX_base() - var5 / 2 - var7;
                this.minCachedTileY = this.getDisplayY_base() - var6 / 2 - var7;
                this.cachedPixelsPerTile = this.worldMapRenderer.pixelsPerTile;
                MidiPcmStream.field3456.method7162(this.minCachedTileX, this.minCachedTileY, this.sprite, (float)this.cachedPixelsPerTile / var10);
                this.field4983 = Client.field783;
                var13 = var1 - (var7 + var11 - this.minCachedTileX) * this.worldMapRenderer.pixelsPerTile;
                var14 = var2 - this.worldMapRenderer.pixelsPerTile * (var7 - (var12 - this.minCachedTileY));
            }
            Rasterizer2D.Rasterizer2D_fillRectangleAlpha_base(var1, var2, var3, var4, 0, 128);
            if (1.0f == var10) {
                this.sprite.method9850_base(var13, var14, 192);
            } else {
                this.sprite.method9761_base(var13, var14, (int)((float)var8 * var10), (int)((float)var9 * var10), 192);
            }
        }
    }

    @ObfuscatedName(value="an")
    @ObfuscatedSignature(descriptor="(IIIIB)V", garbageValue="51")
    public void drawOverview_base(int var1, int var2, int var3, int var4) {
        if (this.cacheLoader.isLoaded_base()) {
            if (!this.worldMapRenderer.isLoaded_base()) {
                this.worldMapRenderer.method4733(this.WorldMap_archive, this.currentMapArea.getInternalName_base(), Client.isMembersWorld, Client.revision >= 217);
                if (!this.worldMapRenderer.isLoaded_base()) {
                    return;
                }
            }
            this.worldMapRenderer.drawOverview_base(var1, var2, var3, var4, this.flashingElements, this.flashCycle, this.cyclesPerFlash);
        }
    }

    @ObfuscatedName(value="ag")
    @ObfuscatedSignature(descriptor="(IB)V", garbageValue="0")
    public void setZoomPercentage_base(int var1) {
        this.zoomTarget = this.getZoomFromPercentage_base(var1);
    }

    @ObfuscatedName(value="ad")
    @ObfuscatedSignature(descriptor="(IIIIII)V", garbageValue="-699862709")
    void drawLoading_base(int var1, int var2, int var3, int var4, int var5) {
        int var6 = 20;
        int var7 = var3 / 2 + var1;
        int var8 = var4 / 2 + var2 - 18 - var6;
        Rasterizer2D.Rasterizer2D_fillRectangle_base(var1, var2, var3, var4, -16777216);
        Rasterizer2D.Rasterizer2D_drawRectangle_base(var7 - 152, var8, 304, 34, -65536);
        Rasterizer2D.Rasterizer2D_fillRectangle_base(var7 - 150, var8 + 2, var5 * 3, 30, -65536);
        this.font.drawCentered_base("Loading...", var7, var8 + var6, -1, -1);
    }

    @ObfuscatedName(value="af")
    @ObfuscatedSignature(descriptor="(IB)F", garbageValue="31")
    float getZoomFromPercentage_base(int var1) {
        return var1 == 25 ? 1.0f : (var1 == 37 ? 1.5f : (var1 == 50 ? 2.0f : (var1 == 75 ? 3.0f : (var1 == 100 ? 4.0f : 8.0f))));
    }

    @ObfuscatedName(value="be")
    @ObfuscatedSignature(descriptor="(I)I", garbageValue="1066219424")
    public int getZoomLevel_base() {
        return (double)this.zoomTarget == 1.0 ? 25 : ((double)this.zoomTarget == 1.5 ? 37 : (2.0 == (double)this.zoomTarget ? 50 : ((double)this.zoomTarget == 3.0 ? 75 : (4.0 == (double)this.zoomTarget ? 100 : 200))));
    }

    @ObfuscatedName(value="bd")
    @ObfuscatedSignature(descriptor="(B)V", garbageValue="123")
    public void loadCache_base() {
        this.cacheLoader.load_base();
    }

    @ObfuscatedName(value="bl")
    @ObfuscatedSignature(descriptor="(I)Z", garbageValue="369984889")
    public boolean isCacheLoaded_base() {
        return this.cacheLoader.isLoaded_base();
    }

    @ObfuscatedName(value="bi")
    @ObfuscatedSignature(descriptor="(II)Ljv;", garbageValue="1808256615")
    public WorldMapArea method8799(int var1) {
        WorldMapArea var3;
        Iterator var2 = this.details.values().iterator();
        do {
            if (var2.hasNext()) continue;
            return null;
        } while ((var3 = (WorldMapArea)var2.next()).getId_base() != var1);
        return var3;
    }

    @ObfuscatedName(value="bv")
    @ObfuscatedSignature(descriptor="(III)V", garbageValue="-678637606")
    public void setWorldMapPositionTarget_base(int var1, int var2) {
        if (this.currentMapArea != null && this.currentMapArea.containsPosition_base(var1, var2)) {
            this.worldMapTargetX = var1 - this.currentMapArea.getRegionLowX_base() * 64;
            this.worldMapTargetY = var2 - this.currentMapArea.getRegionLowY_base() * 64;
        }
    }

    @ObfuscatedName(value="bf")
    @ObfuscatedSignature(descriptor="(III)V", garbageValue="-1573739056")
    public void setWorldMapPositionTargetInstant_base(int var1, int var2) {
        if (this.currentMapArea != null) {
            this.method8721(var1 - this.currentMapArea.getRegionLowX_base() * 64, var2 - this.currentMapArea.getRegionLowY_base() * 64, true, (byte)3);
            this.worldMapTargetX = -1;
            this.worldMapTargetY = -1;
        }
    }

    @ObfuscatedName(value="bg")
    @ObfuscatedSignature(descriptor="(IIII)V", garbageValue="-13928817")
    public void jumpToSourceCoord_base(int var1, int var2, int var3) {
        int[] var4;
        if (this.currentMapArea != null && (var4 = this.currentMapArea.position_base(var1, var2, var3)) != null) {
            this.setWorldMapPositionTarget_base(var4[0], var4[1]);
        }
    }

    @ObfuscatedName(value="ba")
    @ObfuscatedSignature(descriptor="(IIII)V", garbageValue="996468240")
    public void jumpToSourceCoordInstant_base(int var1, int var2, int var3) {
        int[] var4;
        if (this.currentMapArea != null && (var4 = this.currentMapArea.position_base(var1, var2, var3)) != null) {
            this.setWorldMapPositionTargetInstant_base(var4[0], var4[1]);
        }
    }

    @ObfuscatedName(value="bm")
    @ObfuscatedSignature(descriptor="(B)I", garbageValue="-26")
    public int getDisplayX_base() {
        return this.currentMapArea == null ? -1 : this.centerTileX + this.currentMapArea.getRegionLowX_base() * 64;
    }

    @ObfuscatedName(value="bp")
    @ObfuscatedSignature(descriptor="(I)I", garbageValue="-853833323")
    public int getDisplayY_base() {
        return this.currentMapArea == null ? -1 : this.centerTileY + this.currentMapArea.getRegionLowY_base() * 64;
    }

    @ObfuscatedName(value="bw")
    @ObfuscatedSignature(descriptor="(B)Lmh;", garbageValue="0")
    public Coord method8750() {
        return this.currentMapArea == null ? null : this.currentMapArea.method4552(this.getDisplayX_base(), this.getDisplayY_base());
    }

    @ObfuscatedName(value="bj")
    @ObfuscatedSignature(descriptor="(I)I", garbageValue="-1549197910")
    public int getDisplayWith_base() {
        return this.worldMapDisplayWidth;
    }

    @ObfuscatedName(value="bn")
    @ObfuscatedSignature(descriptor="(I)I", garbageValue="-847455478")
    public int getDisplayHeight_base() {
        return this.worldMapDisplayHeight;
    }

    @ObfuscatedName(value="bo")
    @ObfuscatedSignature(descriptor="(II)V", garbageValue="-857515700")
    public void setMaxFlashCount_base(int var1) {
        if (var1 >= 1) {
            this.maxFlashCount = var1;
        }
    }

    @ObfuscatedName(value="bt")
    @ObfuscatedSignature(descriptor="(I)V", garbageValue="1866064784")
    public void resetMaxFlashCount_base() {
        this.maxFlashCount = 3;
    }

    @ObfuscatedName(value="bu")
    @ObfuscatedSignature(descriptor="(IB)V", garbageValue="-90")
    public void setCyclesPerFlash_base(int var1) {
        if (var1 >= 1) {
            this.cyclesPerFlash = var1;
        }
    }

    @ObfuscatedName(value="by")
    @ObfuscatedSignature(descriptor="(I)V", garbageValue="1119701020")
    public void resetCyclesPerFlash_base() {
        this.cyclesPerFlash = 50;
    }

    @ObfuscatedName(value="bh")
    @ObfuscatedSignature(descriptor="(ZI)V", garbageValue="1336488312")
    public void setPerpetualFlash_base(boolean var1) {
        this.perpetualFlash = var1;
    }

    @ObfuscatedName(value="bz")
    @ObfuscatedSignature(descriptor="(IB)V", garbageValue="41")
    public void flashElement_base(int var1) {
        this.flashingElements = new HashSet();
        this.flashingElements.add(var1);
        this.flashCount = 0;
        this.flashCycle = 0;
    }

    @ObfuscatedName(value="bc")
    @ObfuscatedSignature(descriptor="(II)V", garbageValue="-1850840845")
    public void flashCategory_base(int var1) {
        this.flashingElements = new HashSet();
        this.flashCount = 0;
        this.flashCycle = 0;
        for (int var2 = 0; var2 < class137.WorldMapElement_count; ++var2) {
            if (class141.method3209(var2) == null || class141.method3209((int)var2).category != var1) continue;
            this.flashingElements.add(class141.method3209((int)var2).objectId);
        }
    }

    @ObfuscatedName(value="bs")
    @ObfuscatedSignature(descriptor="(I)V", garbageValue="1649001731")
    public void stopCurrentFlashes_base() {
        this.flashingElements = null;
    }

    @ObfuscatedName(value="bx")
    @ObfuscatedSignature(descriptor="(ZB)V", garbageValue="0")
    public void setElementsDisabled_base(boolean var1) {
        this.elementsDisabled = !var1;
    }

    @ObfuscatedName(value="bb")
    @ObfuscatedSignature(descriptor="(IZB)V", garbageValue="125")
    public void disableElement_base(int var1, boolean var2) {
        if (!var2) {
            this.enabledElements.add(var1);
        } else {
            this.enabledElements.remove(var1);
        }
        this.method8900_base();
    }

    @ObfuscatedName(value="bk")
    @ObfuscatedSignature(descriptor="(IZI)V", garbageValue="1569784149")
    public void setCategoryDisabled_base(int var1, boolean var2) {
        if (!var2) {
            this.enabledCategories.add(var1);
        } else {
            this.enabledCategories.remove(var1);
        }
        for (int var3 = 0; var3 < class137.WorldMapElement_count; ++var3) {
            if (class141.method3209(var3) == null || class141.method3209((int)var3).category != var1) continue;
            int var4 = class141.method3209((int)var3).objectId;
            if (!var2) {
                this.enabledElementIds.add(var4);
                continue;
            }
            this.enabledElementIds.remove(var4);
        }
        this.method8900_base();
    }

    @ObfuscatedName(value="br")
    @ObfuscatedSignature(descriptor="(B)Z", garbageValue="41")
    public boolean getElementsDisabled_base() {
        return !this.elementsDisabled;
    }

    @ObfuscatedName(value="bq")
    @ObfuscatedSignature(descriptor="(II)Z", garbageValue="2012466674")
    public boolean isElementDisabled_base(int var1) {
        return !this.enabledElements.contains(var1);
    }

    @ObfuscatedName(value="cf")
    @ObfuscatedSignature(descriptor="(II)Z", garbageValue="-1791520679")
    public boolean isCategoryDisabled_base(int var1) {
        return !this.enabledCategories.contains(var1);
    }

    @ObfuscatedName(value="cg")
    @ObfuscatedSignature(descriptor="(B)V", garbageValue="96")
    void method8900_base() {
        this.field4943.clear();
        this.field4943.addAll(this.enabledElements);
        this.field4943.addAll(this.enabledElementIds);
    }

    @ObfuscatedName(value="cv")
    @ObfuscatedSignature(descriptor="(IIIIIII)V", garbageValue="-1420454539")
    public void addElementMenuOptions_base(int var1, int var2, int var3, int var4, int var5, int var6) {
        int var8;
        int var7;
        List var9;
        if (this.cacheLoader.isLoaded_base() && !(var9 = this.worldMapRenderer.method4764_base(this.centerTileX - (var7 = (int)Math.ceil((float)var3 / this.zoom)) / 2 - 1, this.centerTileY - (var8 = (int)Math.ceil((float)var4 / this.zoom)) / 2 - 1, var7 / 2 + this.centerTileX + 1, var8 / 2 + this.centerTileY + 1, var1, var2, var3, var4, var5, var6)).isEmpty()) {
            boolean var13;
            Iterator var10 = var9.iterator();
            do {
                if (!var10.hasNext()) {
                    return;
                }
                AbstractWorldMapIcon var11 = (AbstractWorldMapIcon)var10.next();
                WorldMapElement var12 = class141.method3209(var11.getElement_base());
                var13 = false;
                for (int var14 = this.menuOpcodes.length - 1; var14 >= 0; --var14) {
                    if (var12.menuActions[var14] == null) continue;
                    WorldMapSectionType.insertMenuItemNoShift_base(var12.menuActions[var14], var12.menuTargetName, this.menuOpcodes[var14], var11.getElement_base(), var11.coord1.packed_base(), var11.coord2.packed_base());
                    var13 = true;
                }
            } while (!var13);
        }
    }

    @ObfuscatedName(value="cx")
    @ObfuscatedSignature(descriptor="(ILmh;I)Lmh;", garbageValue="1628169243")
    public Coord method8768(int var1, Coord var2) {
        if (!this.cacheLoader.isLoaded_base()) {
            return null;
        }
        if (!this.worldMapRenderer.isLoaded_base()) {
            return null;
        }
        if (!this.currentMapArea.containsPosition_base(var2.x, var2.y)) {
            return null;
        }
        HashMap var3 = this.worldMapRenderer.buildIcons_base();
        List var4 = (List)var3.get(var1);
        if (var4 != null && !var4.isEmpty()) {
            AbstractWorldMapIcon var5 = null;
            int var6 = -1;
            Iterator var7 = var4.iterator();
            while (true) {
                if (!var7.hasNext()) {
                    return var5.coord2;
                }
                AbstractWorldMapIcon var8 = (AbstractWorldMapIcon)var7.next();
                int var9 = var8.coord2.x - var2.x;
                int var10 = var8.coord2.y - var2.y;
                int var11 = var9 * var9 + var10 * var10;
                if (var11 == 0) {
                    return var8.coord2;
                }
                if (var11 >= var6 && var5 != null) continue;
                var5 = var8;
                var6 = var11;
            }
        }
        return null;
    }

    @ObfuscatedName(value="cp")
    @ObfuscatedSignature(descriptor="(IILmh;Lmh;B)V", garbageValue="84")
    public void method8769(int var1, int var2, Coord var3, Coord var4) {
        ScriptEvent var5 = new ScriptEvent();
        WorldMapEvent var6 = new WorldMapEvent(var2, var3, var4);
        var5.setArgs_base(new Object[]{var6});
        switch (var1) {
            case 1008: {
                var5.setType_base(10);
                break;
            }
            case 1009: {
                var5.setType_base(11);
                break;
            }
            case 1010: {
                var5.setType_base(12);
                break;
            }
            case 1011: {
                var5.setType_base(13);
                break;
            }
            case 1012: {
                var5.setType_base(14);
            }
        }
        class157.method3403(var5);
    }

    @ObfuscatedName(value="ce")
    @ObfuscatedSignature(descriptor="(B)Ljc;", garbageValue="-80")
    public AbstractWorldMapIcon method8770() {
        if (!this.cacheLoader.isLoaded_base()) {
            return null;
        }
        if (!this.worldMapRenderer.isLoaded_base()) {
            return null;
        }
        HashMap var1 = this.worldMapRenderer.buildIcons_base();
        this.field4974 = new LinkedList();
        for (List var3 : var1.values()) {
            this.field4974.addAll(var3);
        }
        this.iconIterator = this.field4974.iterator();
        return this.method8840();
    }

    @ObfuscatedName(value="ci")
    @ObfuscatedSignature(descriptor="(B)Ljc;", garbageValue="94")
    public AbstractWorldMapIcon method8840() {
        AbstractWorldMapIcon var1;
        if (this.iconIterator == null) {
            return null;
        }
        do {
            if (this.iconIterator.hasNext()) continue;
            return null;
        } while ((var1 = (AbstractWorldMapIcon)this.iconIterator.next()).getElement_base() == -1);
        return var1;
    }

    @Override
    public RSWorldMapRenderer getWorldMapRenderer() {
        return this.worldMapRenderer;
    }

    @Override
    public int getWorldMapX() {
        return this.centerTileX;
    }

    @Override
    public void setWorldMapPositionTarget(int var1, int var2) {
        this.setWorldMapPositionTarget_base(var1, var2);
    }

    @Override
    public int getWorldMapY() {
        return this.centerTileY;
    }

    @Override
    public Point getWorldMapPosition() {
        RSWorldMapRenderer var1 = this.getWorldMapRenderer();
        int var2 = this.getWorldMapX() + var1.getSurfaceOffsetX();
        int var3 = this.getWorldMapY() + var1.getSurfaceOffsetY();
        return new Point(var2, var3);
    }

    @Override
    public void setWorldMapPositionTarget(WorldPoint var1) {
        this.setWorldMapPositionTarget(var1.getX(), var1.getY());
    }

    @Override
    public int getWorldMapTargetX() {
        return this.worldMapTargetX;
    }

    @Override
    public int getWorldMapTargetY() {
        return this.worldMapTargetY;
    }

    @Override
    public float getWorldMapZoom() {
        return this.zoom;
    }

    @Override
    public int getWorldMapDisplayWidth() {
        return this.worldMapDisplayWidth;
    }

    @Override
    public int getWorldMapDisplayHeight() {
        return this.worldMapDisplayHeight;
    }

    @Override
    public int getWorldMapDisplayX() {
        return this.worldMapDisplayX;
    }

    @Override
    public int getWorldMapDisplayY() {
        return this.worldMapDisplayY;
    }

    @Override
    public void setWorldMapPosition(int var1, int var2, boolean var3) {
        this.method8721(var1, var2, var3, (byte)3);
    }

    @Override
    public RSWorldMapArea getWorldMapData() {
        return this.method8901();
    }

    @Override
    public void initializeWorldMap(WorldMapData var1) {
        this.method8730((WorldMapArea)var1);
    }

    @ObfuscatedName(value="it")
    @ObfuscatedSignature(descriptor="(Ldf;I)V", garbageValue="-921124497")
    static final void method8924(Actor var0) {
        int var7;
        int var4;
        int var3;
        int var2;
        if (var0.targetIndex != -1) {
            Actor var1 = null;
            var2 = 65536;
            var1 = var0.targetIndex < var2 ? Client.npcs[var0.targetIndex] : Client.players[var0.targetIndex - var2];
            if (var1 != null) {
                var3 = var0.x - ((Actor)var1).x;
                var4 = var0.y - ((Actor)var1).y;
                if (var3 != 0 || var4 != 0) {
                    var0.orientation = SequenceDefinition.method4094_base(var3, var4);
                }
            } else if (var0.false0) {
                var0.targetIndex = -1;
                var0.interactingChanged(-1);
                var0.false0 = false;
            }
        }
        if (var0.pathLength == 0 || var0.field1245 > 0) {
            int var72 = -1;
            if (var0.field1178 != -1 && var0.field1210 != -1) {
                var2 = var0.field1178 * 128 - NpcOverrides.baseX * 128 + 64;
                var3 = var0.field1210 * 128 - class101.baseY * 128 + 64;
                var4 = var0.x - var2;
                int var5 = var0.y - var3;
                if (var4 != 0 || var5 != 0) {
                    var72 = SequenceDefinition.method4094_base(var4, var5);
                }
            } else if (var0.field1208 != -1) {
                var72 = var0.field1208;
            }
            if (var72 != -1) {
                var0.orientation = var72;
                if (var0.field1211) {
                    var0.rotation = var0.orientation;
                }
            }
            var0.method2480_base();
        }
        if ((var7 = var0.orientation - var0.rotation & 0x7FF) != 0) {
            boolean var8 = true;
            boolean var9 = true;
            ++var0.field1192;
            var4 = var7 > 1024 ? -1 : 1;
            var0.rotation += var0.field1240 * var4;
            boolean var10 = true;
            if (var7 < var0.field1240 || var7 > 2048 - var0.field1240) {
                var0.rotation = var0.orientation;
                var10 = false;
            }
            if (var0.field1240 > 0 && var0.movementSequence == var0.idleSequence && (var0.field1192 > 25 || var10)) {
                var0.movementSequence = var4 == -1 && var0.turnLeftSequence != -1 ? var0.turnLeftSequence : (var4 == 1 && var0.turnRightSequence != -1 ? var0.turnRightSequence : var0.walkSequence);
            }
            var0.rotation &= 0x7FF;
        } else {
            if (var0.false0) {
                var0.targetIndex = -1;
                var0.interactingChanged(-1);
                var0.false0 = false;
            }
            var0.field1192 = 0;
        }
    }
}

