/*
 * Decompiled with CFR 0.152.
 */
package mapped;

import mapped.Buffer;
import net.runelite.mapping.ObfuscatedName;
import net.runelite.mapping.ObfuscatedSignature;
import net.runelite.rs.api.RSSoundEnvelope;

@ObfuscatedName(value="bh")
public class SoundEnvelope
implements RSSoundEnvelope {
    @ObfuscatedName(value="at")
    int segments = 2;
    @ObfuscatedName(value="ah")
    int[] durations = new int[2];
    @ObfuscatedName(value="ar")
    int[] phases = new int[2];
    @ObfuscatedName(value="ao")
    int start;
    @ObfuscatedName(value="ab")
    int end;
    @ObfuscatedName(value="au")
    int form;
    @ObfuscatedName(value="aa")
    int ticks;
    @ObfuscatedName(value="ac")
    int phaseIndex;
    @ObfuscatedName(value="al")
    int step;
    @ObfuscatedName(value="az")
    int amplitude;
    @ObfuscatedName(value="ap")
    int max;

    SoundEnvelope() {
        this.durations[0] = 0;
        this.durations[1] = 65535;
        this.phases[0] = 0;
        this.phases[1] = 65535;
    }

    @ObfuscatedName(value="at")
    @ObfuscatedSignature(descriptor="(Luj;)V")
    final void method849(Buffer var1) {
        this.form = var1.readUnsignedByte_base();
        this.start = var1.readInt_base();
        this.end = var1.readInt_base();
        this.method861(var1);
    }

    @ObfuscatedName(value="ah")
    @ObfuscatedSignature(descriptor="(Luj;)V")
    final void method861(Buffer var1) {
        this.segments = var1.readUnsignedByte_base();
        this.durations = new int[this.segments];
        this.phases = new int[this.segments];
        for (int var2 = 0; var2 < this.segments; ++var2) {
            this.durations[var2] = var1.readUnsignedShort_base();
            this.phases[var2] = var1.readUnsignedShort_base();
        }
    }

    @ObfuscatedName(value="ar")
    final void reset_base() {
        this.ticks = 0;
        this.phaseIndex = 0;
        this.step = 0;
        this.amplitude = 0;
        this.max = 0;
    }

    @ObfuscatedName(value="ao")
    final int doStep_base(int var1) {
        if (this.max >= this.ticks) {
            this.amplitude = this.phases[this.phaseIndex++] << 15;
            if (this.phaseIndex >= this.segments) {
                this.phaseIndex = this.segments - 1;
            }
            this.ticks = (int)((double)this.durations[this.phaseIndex] / 65536.0 * (double)var1);
            if (this.ticks > this.max) {
                this.step = ((this.phases[this.phaseIndex] << 15) - this.amplitude) / (this.ticks - this.max);
            }
        }
        this.amplitude += this.step;
        ++this.max;
        return this.amplitude - this.step >> 15;
    }
}

