/*
 * Decompiled with CFR 0.152.
 */
package mapped;

import mapped.Canvas;
import mapped.Client;
import mapped.DynamicObject;
import mapped.Model;
import mapped.Renderable;
import mapped.SequenceDefinition;
import mapped.SpotAnimationDefinition;
import mapped.SpriteMask;
import net.runelite.api.Actor;
import net.runelite.api.Animation;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.events.ProjectileMoved;
import net.runelite.api.events.ProjectileSpawned;
import net.runelite.api.events.VolumeChanged;
import net.runelite.mapping.ObfuscatedGetter;
import net.runelite.mapping.ObfuscatedName;
import net.runelite.mapping.ObfuscatedSignature;
import net.runelite.rs.api.RSNPC;
import net.runelite.rs.api.RSPlayer;
import net.runelite.rs.api.RSProjectile;

@ObfuscatedName(value="ck")
public final class Projectile
extends Renderable
implements RSProjectile {
    @ObfuscatedName(value="vl")
    @ObfuscatedGetter(intValue=-1106968031)
    static int field937;
    @ObfuscatedName(value="at")
    @ObfuscatedGetter(intValue=-1715665897)
    int id;
    @ObfuscatedName(value="ah")
    @ObfuscatedGetter(intValue=950599391)
    int plane;
    @ObfuscatedName(value="ar")
    @ObfuscatedGetter(intValue=1474959745)
    int sourceX;
    @ObfuscatedName(value="ao")
    @ObfuscatedGetter(intValue=-1673087401)
    int sourceY;
    @ObfuscatedName(value="ab")
    @ObfuscatedGetter(intValue=-1451961285)
    int sourceZ;
    @ObfuscatedName(value="au")
    @ObfuscatedGetter(intValue=-1112467891)
    int endHeight;
    @ObfuscatedName(value="aa")
    @ObfuscatedGetter(intValue=-1278515723)
    int field960;
    @ObfuscatedName(value="ac")
    @ObfuscatedGetter(intValue=799813617)
    int field938;
    @ObfuscatedName(value="al")
    @ObfuscatedGetter(intValue=-499492361)
    int field945;
    @ObfuscatedName(value="az")
    @ObfuscatedGetter(intValue=-1803322589)
    int cycleStart;
    @ObfuscatedName(value="ap")
    @ObfuscatedGetter(intValue=-605935351)
    int cycleEnd;
    @ObfuscatedName(value="av")
    @ObfuscatedGetter(intValue=-822202755)
    int slope;
    @ObfuscatedName(value="ax")
    @ObfuscatedGetter(intValue=-584446471)
    int startHeight;
    @ObfuscatedName(value="as")
    @ObfuscatedGetter(intValue=-489123553)
    int field950;
    @ObfuscatedName(value="ay")
    @ObfuscatedGetter(intValue=868463931)
    int targetIndex;
    @ObfuscatedName(value="ak")
    boolean isMoving = false;
    @ObfuscatedName(value="aj")
    double x;
    @ObfuscatedName(value="am")
    double y;
    @ObfuscatedName(value="aq")
    double z;
    @ObfuscatedName(value="ai")
    double speedX;
    @ObfuscatedName(value="aw")
    double speedY;
    @ObfuscatedName(value="ae")
    double speed;
    @ObfuscatedName(value="an")
    double speedZ;
    @ObfuscatedName(value="ag")
    double accelerationZ;
    @ObfuscatedName(value="ad")
    @ObfuscatedGetter(intValue=-777446121)
    int yaw;
    @ObfuscatedName(value="af")
    @ObfuscatedGetter(intValue=-1808297649)
    int pitch;
    @ObfuscatedName(value="be")
    @ObfuscatedSignature(descriptor="Lhx;")
    SequenceDefinition sequenceDefinition;
    @ObfuscatedName(value="bd")
    @ObfuscatedGetter(intValue=93342027)
    int frame = 0;
    @ObfuscatedName(value="bl")
    @ObfuscatedGetter(intValue=1377913919)
    int frameCycle = 0;
    public int targetX;
    public int targetY;

    Projectile(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11) {
        this.id = var1;
        this.plane = var2;
        this.sourceX = var3;
        this.sourceY = var4;
        this.sourceZ = var5;
        this.cycleStart = var6;
        this.cycleEnd = var7;
        this.slope = var8;
        this.startHeight = var9;
        this.targetIndex = var10;
        this.endHeight = var11;
        this.isMoving = false;
        int var12 = Canvas.method324((int)this.id).sequence;
        this.sequenceDefinition = var12 != -1 ? DynamicObject.method2245(var12) : null;
        this.rl$$init();
    }

    Projectile(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12) {
        this(var1, var2, var3, var4, var5, var6, var7, var8, var9, var11, var12);
        this.field950 = var10;
        this.rl$$init();
    }

    @ObfuscatedName(value="at")
    @ObfuscatedSignature(descriptor="(IIIII)V", garbageValue="34043964")
    final void setDestination_base(int var1, int var2, int var3, int var4) {
        double var5;
        this.projectileMoved(var1, var2, var3, var4);
        this.field960 = var1;
        this.field938 = var2;
        this.field945 = var3;
        if (!this.isMoving) {
            var5 = this.field960 - this.sourceX;
            double var7 = this.field938 - this.sourceY;
            double var9 = Math.sqrt(var7 * var7 + var5 * var5);
            this.x = (double)this.sourceX + (double)this.startHeight * var5 / var9;
            this.y = (double)this.startHeight * var7 / var9 + (double)this.sourceY;
            this.z = this.sourceZ;
        }
        var5 = this.cycleEnd + 1 - var4;
        this.speedX = ((double)this.field960 - this.x) / var5;
        this.speedY = ((double)this.field938 - this.y) / var5;
        this.speed = Math.sqrt(this.speedY * this.speedY + this.speedX * this.speedX);
        if (!this.isMoving) {
            this.speedZ = -this.speed * Math.tan(0.02454369 * (double)this.slope);
        }
        this.accelerationZ = 2.0 * ((double)this.field945 - this.z - this.speedZ * var5) / (var5 * var5);
    }

    @Override
    @ObfuscatedName(value="ah")
    @ObfuscatedSignature(descriptor="(B)Lka;", garbageValue="1")
    protected final Model vmethod5504() {
        SpotAnimationDefinition var1 = Canvas.method324(this.id);
        Model var2 = var1.method3762(this.frame);
        if (var2 == null) {
            return null;
        }
        var2.rotateZ_base(this.pitch);
        return var2;
    }

    @ObfuscatedName(value="ar")
    @ObfuscatedSignature(descriptor="(II)V", garbageValue="-1019112167")
    final void advance_base(int var1) {
        this.isMoving = true;
        this.x += (double)var1 * this.speedX;
        this.y += (double)var1 * this.speedY;
        this.z += (double)var1 * this.speedZ + (double)var1 * (double)var1 * 0.5 * this.accelerationZ;
        this.speedZ += this.accelerationZ * (double)var1;
        this.yaw = (int)(Math.atan2(this.speedX, this.speedY) * 325.949) + 1024 & 0x7FF;
        this.pitch = (int)(Math.atan2(this.speedZ, this.speed) * 325.949) & 0x7FF;
        if (this.sequenceDefinition != null) {
            if (!this.sequenceDefinition.isCachedModelIdSet_base()) {
                this.frameCycle += var1;
                while (true) {
                    if (this.frameCycle <= this.sequenceDefinition.frameLengths[this.frame]) {
                        return;
                    }
                    this.frameCycle -= this.sequenceDefinition.frameLengths[this.frame];
                    ++this.frame;
                    if (this.frame < this.sequenceDefinition.frameIds.length) continue;
                    this.frame -= this.sequenceDefinition.frameCount;
                    if (this.frame >= 0 && this.frame < this.sequenceDefinition.frameIds.length) continue;
                    this.frame = 0;
                }
            }
            this.frame += var1;
            int var2 = this.sequenceDefinition.method4064_base();
            if (this.frame >= var2) {
                this.frame = var2 - this.sequenceDefinition.frameCount;
            }
        }
    }

    @Override
    public int getRsInteracting() {
        return this.targetIndex;
    }

    public void projectileMoved(int var1, int var2, int var3, int var4) {
        this.targetX = var1;
        this.targetY = var2;
        LocalPoint var5 = new LocalPoint(var1, var2);
        ProjectileMoved var6 = new ProjectileMoved();
        var6.setProjectile(this);
        var6.setPosition(var5);
        var6.setZ(var3);
        SpriteMask.client.getCallbacks().post(var6);
    }

    @Override
    public int getEndCycle() {
        return this.cycleEnd;
    }

    private void rl$$init() {
        ProjectileSpawned var1 = new ProjectileSpawned();
        var1.setProjectile(this);
        SpriteMask.client.getCallbacks().post(var1);
    }

    @Override
    public int getRemainingCycles() {
        int var1 = SpriteMask.client.getGameCycle();
        return this.getEndCycle() - var1;
    }

    @Override
    public Actor getInteracting() {
        int var1 = this.getRsInteracting();
        if (var1 == 0) {
            return null;
        }
        if (var1 > 0) {
            int var2 = var1 - 1;
            RSNPC[] var4 = SpriteMask.client.getCachedNPCs();
            return var4[var2];
        }
        int var2 = -var1 - 1;
        if (var2 == SpriteMask.client.getLocalPlayerIndex()) {
            return SpriteMask.client.getLocalPlayer();
        }
        RSPlayer[] var3 = SpriteMask.client.getCachedPlayers();
        return var3[var2];
    }

    @Override
    public LocalPoint getTarget() {
        return new LocalPoint(this.targetX, this.targetY);
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public int getFloor() {
        return this.plane;
    }

    @Override
    public int getX1() {
        return this.sourceX;
    }

    @Override
    public int getY1() {
        return this.sourceY;
    }

    @Override
    public int getHeight() {
        return this.sourceZ;
    }

    @Override
    public int getEndHeight() {
        return this.endHeight;
    }

    @Override
    public int getStartCycle() {
        return this.cycleStart;
    }

    @Override
    public void setEndCycle(int var1) {
        this.cycleEnd = var1;
    }

    @Override
    public int getSlope() {
        return this.slope;
    }

    @Override
    public int getStartHeight() {
        return this.startHeight;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getZ() {
        return this.z;
    }

    @Override
    public double getVelocityX() {
        return this.speedX;
    }

    @Override
    public double getVelocityY() {
        return this.speedY;
    }

    @Override
    public double getScalar() {
        return this.speed;
    }

    @Override
    public double getVelocityZ() {
        return this.speedZ;
    }

    @Override
    public void setDestination(int var1, int var2, int var3, int var4) {
        this.setDestination_base(var1, var2, var3, var4);
    }

    @ObfuscatedName(value="jm")
    @ObfuscatedSignature(descriptor="(I)Z", garbageValue="-1070521773")
    static boolean method2209_base() {
        return (Client.drawPlayerNames & 8) != 0;
    }

    @ObfuscatedName(value="mp")
    @ObfuscatedSignature(descriptor="(II)V", garbageValue="2039275921")
    static final void changeGameOptions_base(int var0) {
        Client.copy$changeGameOptions(var0, 2039275921);
        int var1 = SpriteMask.client.getVarpDefinition(var0).getType();
        if (var1 == 3 || var1 == 4 || var1 == 10) {
            VolumeChanged var2 = new VolumeChanged(var1 == 3 ? VolumeChanged.Type.MUSIC : (var1 == 4 ? VolumeChanged.Type.EFFECTS : VolumeChanged.Type.AREA));
            SpriteMask.client.getCallbacks().post(var2);
        }
    }

    @Override
    public Animation getAnimation() {
        return this.sequenceDefinition;
    }

    @Override
    public int getAnimationFrame() {
        return this.frame;
    }
}

