/*
 * Decompiled with CFR 0.152.
 */
package mapped;

import mapped.Buffer;
import net.runelite.mapping.ObfuscatedName;
import net.runelite.mapping.ObfuscatedSignature;
import net.runelite.rs.api.RSMidiFileReader;

@ObfuscatedName(value="mx")
public class MidiFileReader
implements RSMidiFileReader {
    @ObfuscatedName(value="az")
    static final byte[] field3466 = new byte[]{2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 1, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    @ObfuscatedName(value="at")
    @ObfuscatedSignature(descriptor="Luj;")
    Buffer buffer = new Buffer(null);
    @ObfuscatedName(value="ah")
    int division;
    @ObfuscatedName(value="ar")
    int[] trackStarts;
    @ObfuscatedName(value="ao")
    int[] trackPositions;
    @ObfuscatedName(value="ab")
    int[] trackLengths;
    @ObfuscatedName(value="au")
    int[] field3462;
    @ObfuscatedName(value="aa")
    int field3464;
    @ObfuscatedName(value="al")
    long field3463;

    MidiFileReader() {
    }

    @ObfuscatedName(value="at")
    void parse_base(byte[] var1) {
        this.buffer.array = var1;
        this.buffer.offset = 10;
        int var2 = this.buffer.readUnsignedShort_base();
        this.division = this.buffer.readUnsignedShort_base();
        this.field3464 = 500000;
        this.trackStarts = new int[var2];
        int var3 = 0;
        while (var3 < var2) {
            int var4 = this.buffer.readInt_base();
            int var5 = this.buffer.readInt_base();
            if (var4 == 1297379947) {
                this.trackStarts[var3] = this.buffer.offset;
                ++var3;
            }
            this.buffer.offset += var5;
        }
        this.field3463 = 0L;
        this.trackPositions = new int[var2];
        for (var3 = 0; var3 < var2; ++var3) {
            this.trackPositions[var3] = this.trackStarts[var3];
        }
        this.trackLengths = new int[var2];
        this.field3462 = new int[var2];
    }

    @ObfuscatedName(value="ah")
    void clear_base() {
        this.buffer.array = null;
        this.trackStarts = null;
        this.trackPositions = null;
        this.trackLengths = null;
        this.field3462 = null;
    }

    @ObfuscatedName(value="ar")
    boolean isReady_base() {
        return this.buffer.array != null;
    }

    @ObfuscatedName(value="ao")
    int trackCount_base() {
        return this.trackPositions.length;
    }

    @ObfuscatedName(value="ab")
    void gotoTrack_base(int var1) {
        this.buffer.offset = this.trackPositions[var1];
    }

    @ObfuscatedName(value="au")
    void markTrackPosition_base(int var1) {
        this.trackPositions[var1] = this.buffer.offset;
    }

    @ObfuscatedName(value="aa")
    void setTrackDone_base() {
        this.buffer.offset = -1;
    }

    @ObfuscatedName(value="ac")
    void readTrackLength_base(int var1) {
        int var2 = this.buffer.readVarInt_base();
        int n = var1;
        this.trackLengths[n] = this.trackLengths[n] + var2;
    }

    @ObfuscatedName(value="al")
    int readMessage_base(int var1) {
        int var2 = this.readMessage0_base(var1);
        return var2;
    }

    @ObfuscatedName(value="az")
    int readMessage0_base(int var1) {
        int var4;
        int var5;
        byte var2 = this.buffer.array[this.buffer.offset];
        if (var2 < 0) {
            this.field3462[var1] = var5 = var2 & 0xFF;
            ++this.buffer.offset;
        } else {
            var5 = this.field3462[var1];
        }
        if (var5 != 240 && var5 != 247) {
            return this.method6144_base(var1, var5);
        }
        int var3 = this.buffer.readVarInt_base();
        if (var5 == 247 && var3 > 0 && ((var4 = this.buffer.array[this.buffer.offset] & 0xFF) >= 241 && var4 <= 243 || var4 == 246 || var4 == 248 || var4 >= 250 && var4 <= 252 || var4 == 254)) {
            ++this.buffer.offset;
            this.field3462[var1] = var4;
            return this.method6144_base(var1, var4);
        }
        this.buffer.offset += var3;
        return 0;
    }

    @ObfuscatedName(value="ap")
    int method6144_base(int var1, int var2) {
        if (var2 == 255) {
            int var7 = this.buffer.readUnsignedByte_base();
            int var4 = this.buffer.readVarInt_base();
            if (var7 == 47) {
                this.buffer.offset += var4;
                return 1;
            }
            if (var7 == 81) {
                int var5 = this.buffer.readUnsignedMedium_base();
                int var6 = this.trackLengths[var1];
                this.field3463 += (long)var6 * (long)(this.field3464 - var5);
                this.field3464 = var5;
                this.buffer.offset += (var4 -= 3);
                return 2;
            }
            this.buffer.offset += var4;
            return 3;
        }
        byte var3 = field3466[var2 - 128];
        int var4 = var2;
        if (var3 >= 1) {
            var4 = var2 | this.buffer.readUnsignedByte_base() << 8;
        }
        if (var3 >= 2) {
            var4 |= this.buffer.readUnsignedByte_base() << 16;
        }
        return var4;
    }

    @ObfuscatedName(value="av")
    long method6145_base(int var1) {
        return this.field3463 + (long)var1 * (long)this.field3464;
    }

    @ObfuscatedName(value="ax")
    int getPrioritizedTrack_base() {
        int var1 = this.trackPositions.length;
        int var2 = -1;
        int var3 = Integer.MAX_VALUE;
        for (int var4 = 0; var4 < var1; ++var4) {
            if (this.trackPositions[var4] < 0 || this.trackLengths[var4] >= var3) continue;
            var2 = var4;
            var3 = this.trackLengths[var4];
        }
        return var2;
    }

    @ObfuscatedName(value="as")
    boolean isDone_base() {
        int var1 = this.trackPositions.length;
        for (int var2 = 0; var2 < var1; ++var2) {
            if (this.trackPositions[var2] < 0) continue;
            return false;
        }
        return true;
    }

    @ObfuscatedName(value="ay")
    void reset_base(long var1) {
        this.field3463 = var1;
        int var3 = this.trackPositions.length;
        for (int var4 = 0; var4 < var3; ++var4) {
            this.trackLengths[var4] = 0;
            this.field3462[var4] = 0;
            this.buffer.offset = this.trackStarts[var4];
            this.readTrackLength_base(var4);
            this.trackPositions[var4] = this.buffer.offset;
        }
    }
}

