/*
 * Decompiled with CFR 0.152.
 */
package mapped;

import java.util.Random;
import mapped.AudioFilter;
import mapped.Buffer;
import mapped.SoundEnvelope;
import mapped.class421;
import net.runelite.mapping.ObfuscatedName;
import net.runelite.mapping.ObfuscatedSignature;
import net.runelite.rs.api.RSInstrument;

@ObfuscatedName(value="cq")
public class Instrument
implements RSInstrument {
    @ObfuscatedName(value="am")
    static int[] Instrument_samples;
    @ObfuscatedName(value="aq")
    static int[] Instrument_noise;
    @ObfuscatedName(value="ai")
    static int[] Instrument_sine;
    @ObfuscatedName(value="ae")
    static int[] Instrument_phases;
    @ObfuscatedName(value="an")
    static int[] Instrument_delays;
    @ObfuscatedName(value="ag")
    static int[] Instrument_volumeSteps;
    @ObfuscatedName(value="ad")
    static int[] Instrument_pitchSteps;
    @ObfuscatedName(value="af")
    static int[] Instrument_pitchBaseSteps;
    @ObfuscatedName(value="at")
    @ObfuscatedSignature(descriptor="Lbh;")
    SoundEnvelope pitch;
    @ObfuscatedName(value="ah")
    @ObfuscatedSignature(descriptor="Lbh;")
    SoundEnvelope volume;
    @ObfuscatedName(value="ar")
    @ObfuscatedSignature(descriptor="Lbh;")
    SoundEnvelope pitchModifier;
    @ObfuscatedName(value="ao")
    @ObfuscatedSignature(descriptor="Lbh;")
    SoundEnvelope pitchModifierAmplitude;
    @ObfuscatedName(value="ab")
    @ObfuscatedSignature(descriptor="Lbh;")
    SoundEnvelope volumeMultiplier;
    @ObfuscatedName(value="au")
    @ObfuscatedSignature(descriptor="Lbh;")
    SoundEnvelope volumeMultiplierAmplitude;
    @ObfuscatedName(value="aa")
    @ObfuscatedSignature(descriptor="Lbh;")
    SoundEnvelope release;
    @ObfuscatedName(value="ac")
    @ObfuscatedSignature(descriptor="Lbh;")
    SoundEnvelope attack;
    @ObfuscatedName(value="al")
    int[] oscillatorVolume = new int[]{0, 0, 0, 0, 0};
    @ObfuscatedName(value="az")
    int[] oscillatorPitch = new int[]{0, 0, 0, 0, 0};
    @ObfuscatedName(value="ap")
    int[] oscillatorDelays = new int[]{0, 0, 0, 0, 0};
    @ObfuscatedName(value="av")
    int delayTime = 0;
    @ObfuscatedName(value="ax")
    int delayDecay = 100;
    @ObfuscatedName(value="as")
    @ObfuscatedSignature(descriptor="Lci;")
    AudioFilter filter;
    @ObfuscatedName(value="ay")
    @ObfuscatedSignature(descriptor="Lbh;")
    SoundEnvelope filterEnvelope;
    @ObfuscatedName(value="ak")
    int duration = 500;
    @ObfuscatedName(value="aj")
    int offset = 0;

    Instrument() {
    }

    @ObfuscatedName(value="at")
    final int[] synthesize_base(int var1, int var2) {
        int var16;
        int var15;
        int var14;
        int var13;
        int var12;
        int var11;
        class421.clearIntArray_base(Instrument_samples, 0, var1);
        if (var2 < 10) {
            return Instrument_samples;
        }
        double var3 = (double)var1 / ((double)var2 + 0.0);
        this.pitch.reset_base();
        this.volume.reset_base();
        int var5 = 0;
        int var6 = 0;
        int var7 = 0;
        if (this.pitchModifier != null) {
            this.pitchModifier.reset_base();
            this.pitchModifierAmplitude.reset_base();
            var5 = (int)((double)(this.pitchModifier.end - this.pitchModifier.start) * 32.768 / var3);
            var6 = (int)((double)this.pitchModifier.start * 32.768 / var3);
        }
        int var8 = 0;
        int var9 = 0;
        int var10 = 0;
        if (this.volumeMultiplier != null) {
            this.volumeMultiplier.reset_base();
            this.volumeMultiplierAmplitude.reset_base();
            var8 = (int)((double)(this.volumeMultiplier.end - this.volumeMultiplier.start) * 32.768 / var3);
            var9 = (int)((double)this.volumeMultiplier.start * 32.768 / var3);
        }
        for (var11 = 0; var11 < 5; ++var11) {
            if (this.oscillatorVolume[var11] == 0) continue;
            Instrument.Instrument_phases[var11] = 0;
            Instrument.Instrument_delays[var11] = (int)((double)this.oscillatorDelays[var11] * var3);
            Instrument.Instrument_volumeSteps[var11] = (this.oscillatorVolume[var11] << 14) / 100;
            Instrument.Instrument_pitchSteps[var11] = (int)((double)(this.pitch.end - this.pitch.start) * 32.768 * Math.pow(1.0057929410678534, this.oscillatorPitch[var11]) / var3);
            Instrument.Instrument_pitchBaseSteps[var11] = (int)((double)this.pitch.start * 32.768 / var3);
        }
        for (var11 = 0; var11 < var1; ++var11) {
            var12 = this.pitch.doStep_base(var1);
            var13 = this.volume.doStep_base(var1);
            if (this.pitchModifier != null) {
                var14 = this.pitchModifier.doStep_base(var1);
                var15 = this.pitchModifierAmplitude.doStep_base(var1);
                var12 += this.evaluateWave_base(var7, var15, this.pitchModifier.form) >> 1;
                var7 = var7 + var6 + (var14 * var5 >> 16);
            }
            if (this.volumeMultiplier != null) {
                var14 = this.volumeMultiplier.doStep_base(var1);
                var15 = this.volumeMultiplierAmplitude.doStep_base(var1);
                var13 = var13 * ((this.evaluateWave_base(var10, var15, this.volumeMultiplier.form) >> 1) + 32768) >> 15;
                var10 = var10 + var9 + (var14 * var8 >> 16);
            }
            for (var14 = 0; var14 < 5; ++var14) {
                if (this.oscillatorVolume[var14] == 0 || (var15 = Instrument_delays[var14] + var11) >= var1) continue;
                int n = var15;
                Instrument_samples[n] = Instrument_samples[n] + this.evaluateWave_base(Instrument_phases[var14], var13 * Instrument_volumeSteps[var14] >> 15, this.pitch.form);
                int n2 = var14;
                Instrument_phases[n2] = Instrument_phases[n2] + ((var12 * Instrument_pitchSteps[var14] >> 16) + Instrument_pitchBaseSteps[var14]);
            }
        }
        if (this.release != null) {
            this.release.reset_base();
            this.attack.reset_base();
            var11 = 0;
            boolean var19 = false;
            boolean var20 = true;
            for (var14 = 0; var14 < var1; ++var14) {
                var15 = this.release.doStep_base(var1);
                var16 = this.attack.doStep_base(var1);
                var12 = var20 ? (var15 * (this.release.end - this.release.start) >> 8) + this.release.start : (var16 * (this.release.end - this.release.start) >> 8) + this.release.start;
                if ((var11 += 256) >= var12) {
                    var11 = 0;
                    boolean bl = var20 = !var20;
                }
                if (!var20) continue;
                Instrument.Instrument_samples[var14] = 0;
            }
        }
        if (this.delayTime > 0 && this.delayDecay > 0) {
            for (var12 = var11 = (int)((double)this.delayTime * var3); var12 < var1; ++var12) {
                int n = var12;
                Instrument_samples[n] = Instrument_samples[n] + Instrument_samples[var12 - var11] * this.delayDecay / 100;
            }
        }
        if (this.filter.pairs[0] > 0 || this.filter.pairs[1] > 0) {
            this.filterEnvelope.reset_base();
            var11 = this.filterEnvelope.doStep_base(var1 + 1);
            var12 = this.filter.compute_base(0, (float)var11 / 65536.0f);
            var13 = this.filter.compute_base(1, (float)var11 / 65536.0f);
            if (var1 >= var12 + var13) {
                int var17;
                var14 = 0;
                var15 = var13;
                if (var13 > var1 - var12) {
                    var15 = var1 - var12;
                }
                while (var14 < var15) {
                    var16 = (int)((long)Instrument_samples[var14 + var12] * (long)AudioFilter.forwardMultiplier >> 16);
                    for (var17 = 0; var17 < var12; ++var17) {
                        var16 += (int)((long)Instrument_samples[var14 + var12 - 1 - var17] * (long)AudioFilter.coefficients[0][var17] >> 16);
                    }
                    for (var17 = 0; var17 < var14; ++var17) {
                        var16 -= (int)((long)Instrument_samples[var14 - 1 - var17] * (long)AudioFilter.coefficients[1][var17] >> 16);
                    }
                    Instrument.Instrument_samples[var14] = var16;
                    var11 = this.filterEnvelope.doStep_base(var1 + 1);
                    ++var14;
                }
                boolean var21 = true;
                var15 = 128;
                while (true) {
                    int var18;
                    if (var15 > var1 - var12) {
                        var15 = var1 - var12;
                    }
                    while (var14 < var15) {
                        var17 = (int)((long)Instrument_samples[var14 + var12] * (long)AudioFilter.forwardMultiplier >> 16);
                        for (var18 = 0; var18 < var12; ++var18) {
                            var17 += (int)((long)Instrument_samples[var14 + var12 - 1 - var18] * (long)AudioFilter.coefficients[0][var18] >> 16);
                        }
                        for (var18 = 0; var18 < var13; ++var18) {
                            var17 -= (int)((long)Instrument_samples[var14 - 1 - var18] * (long)AudioFilter.coefficients[1][var18] >> 16);
                        }
                        Instrument.Instrument_samples[var14] = var17;
                        var11 = this.filterEnvelope.doStep_base(var1 + 1);
                        ++var14;
                    }
                    if (var14 >= var1 - var12) {
                        while (var14 < var1) {
                            var17 = 0;
                            for (var18 = var14 + var12 - var1; var18 < var12; ++var18) {
                                var17 += (int)((long)Instrument_samples[var14 + var12 - 1 - var18] * (long)AudioFilter.coefficients[0][var18] >> 16);
                            }
                            for (var18 = 0; var18 < var13; ++var18) {
                                var17 -= (int)((long)Instrument_samples[var14 - 1 - var18] * (long)AudioFilter.coefficients[1][var18] >> 16);
                            }
                            Instrument.Instrument_samples[var14] = var17;
                            this.filterEnvelope.doStep_base(var1 + 1);
                            ++var14;
                        }
                        break;
                    }
                    var12 = this.filter.compute_base(0, (float)var11 / 65536.0f);
                    var13 = this.filter.compute_base(1, (float)var11 / 65536.0f);
                    var15 += 128;
                }
            }
        }
        for (var11 = 0; var11 < var1; ++var11) {
            if (Instrument_samples[var11] < Short.MIN_VALUE) {
                Instrument.Instrument_samples[var11] = Short.MIN_VALUE;
            }
            if (Instrument_samples[var11] <= Short.MAX_VALUE) continue;
            Instrument.Instrument_samples[var11] = Short.MAX_VALUE;
        }
        return Instrument_samples;
    }

    @ObfuscatedName(value="ah")
    final int evaluateWave_base(int var1, int var2, int var3) {
        return var3 == 1 ? ((var1 & Short.MAX_VALUE) < 16384 ? var2 : -var2) : (var3 == 2 ? Instrument_sine[var1 & Short.MAX_VALUE] * var2 >> 14 : (var3 == 3 ? (var2 * (var1 & Short.MAX_VALUE) >> 14) - var2 : (var3 == 4 ? var2 * Instrument_noise[var1 / 2607 & Short.MAX_VALUE] : 0)));
    }

    @ObfuscatedName(value="ar")
    @ObfuscatedSignature(descriptor="(Luj;)V")
    final void method1202(Buffer var1) {
        int var4;
        this.pitch = new SoundEnvelope();
        this.pitch.method849(var1);
        this.volume = new SoundEnvelope();
        this.volume.method849(var1);
        int var2 = var1.readUnsignedByte_base();
        if (var2 != 0) {
            --var1.offset;
            this.pitchModifier = new SoundEnvelope();
            this.pitchModifier.method849(var1);
            this.pitchModifierAmplitude = new SoundEnvelope();
            this.pitchModifierAmplitude.method849(var1);
        }
        if ((var2 = var1.readUnsignedByte_base()) != 0) {
            --var1.offset;
            this.volumeMultiplier = new SoundEnvelope();
            this.volumeMultiplier.method849(var1);
            this.volumeMultiplierAmplitude = new SoundEnvelope();
            this.volumeMultiplierAmplitude.method849(var1);
        }
        if ((var2 = var1.readUnsignedByte_base()) != 0) {
            --var1.offset;
            this.release = new SoundEnvelope();
            this.release.method849(var1);
            this.attack = new SoundEnvelope();
            this.attack.method849(var1);
        }
        for (int var3 = 0; var3 < 10 && (var4 = var1.readUShortSmart_base()) != 0; ++var3) {
            this.oscillatorVolume[var3] = var4;
            this.oscillatorPitch[var3] = var1.readShortSmart_base();
            this.oscillatorDelays[var3] = var1.readUShortSmart_base();
        }
        this.delayTime = var1.readUShortSmart_base();
        this.delayDecay = var1.readUShortSmart_base();
        this.duration = var1.readUnsignedShort_base();
        this.offset = var1.readUnsignedShort_base();
        this.filter = new AudioFilter();
        this.filterEnvelope = new SoundEnvelope();
        this.filter.method1158(var1, this.filterEnvelope);
    }

    static {
        int var1;
        Instrument_noise = new int[32768];
        Random var0 = new Random(0L);
        for (var1 = 0; var1 < 32768; ++var1) {
            Instrument.Instrument_noise[var1] = (var0.nextInt() & 2) - 1;
        }
        Instrument_sine = new int[32768];
        for (var1 = 0; var1 < 32768; ++var1) {
            Instrument.Instrument_sine[var1] = (int)(Math.sin((double)var1 / 5215.1903) * 16384.0);
        }
        Instrument_samples = new int[220500];
        Instrument_phases = new int[5];
        Instrument_delays = new int[5];
        Instrument_volumeSteps = new int[5];
        Instrument_pitchSteps = new int[5];
        Instrument_pitchBaseSteps = new int[5];
    }
}

